/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility.io;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ProcessStreamReader
extends Thread {
    private final Process mProcess;
    private final boolean mStdin;
    private final ByteArrayOutputStream mBaos = new ByteArrayOutputStream();

    public static byte[] readAll(Process process, boolean stdin) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ProcessStreamReader.readAll(process, stdin, baos);
        return baos.toByteArray();
    }

    public static void readAll(Process process, boolean stdin, ByteArrayOutputStream baos) {
        byte[] buf = new byte[1024];
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedInputStream in = new BufferedInputStream(stdin ? process.getInputStream() : process.getErrorStream());){
                int read;
                while ((read = ((InputStream)in).read(buf)) >= 0) {
                    baos.write(buf, 0, read);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ProcessStreamReader(Process p, boolean stdin) {
        this.mProcess = p;
        this.mStdin = stdin;
    }

    public byte[] getData() {
        return this.mBaos.toByteArray();
    }

    @Override
    public void run() {
        ProcessStreamReader.readAll(this.mProcess, this.mStdin, this.mBaos);
    }
}

