/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility.io;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;

public class PpmImageDescriptor
extends ImageDescriptor {
    private final String mPath;

    private static String next(BufferedInputStream in, boolean skipLeadingWhiteSpace) throws IOException {
        StringBuilder buffer = new StringBuilder();
        int ch = in.read();
        if (skipLeadingWhiteSpace) {
            while (ch == 32 || ch == 10 || ch == 13 || ch == 9) {
                ch = in.read();
            }
        }
        while (ch != -1 && ch != 32 && ch != 9 && ch != 10 && ch != 13) {
            buffer.append((char)ch);
            ch = in.read();
        }
        return buffer.toString();
    }

    public PpmImageDescriptor(String path) {
        this.mPath = path;
    }

    public ImageData getImageData() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.mPath));){
                if (PpmImageDescriptor.next(in, false).equals("P6")) {
                    int width = Integer.parseInt(PpmImageDescriptor.next(in, true));
                    int height = Integer.parseInt(PpmImageDescriptor.next(in, true));
                    int maxVal = Integer.parseInt(PpmImageDescriptor.next(in, true));
                    if (maxVal > 255) {
                        throw new IOException("Only 24-bit images are supported");
                    }
                    ImageData imgData = new ImageData(width, height, 24, new PaletteData(255, 65280, 0xFF0000));
                    byte[] buffer = new byte[3 * width];
                    int y = 0;
                    while (y < height) {
                        int amt = in.read(buffer);
                        if (amt == -1) {
                            throw new EOFException("Not enough data present [1]");
                        }
                        int remaining = buffer.length - amt;
                        while (remaining > 0) {
                            amt = in.read(buffer, buffer.length - remaining, remaining);
                            if (amt == -1) {
                                throw new EOFException("Not enough data present [2]");
                            }
                            remaining -= amt;
                        }
                        int x = 0;
                        while (x < width) {
                            int i = x * 3;
                            imgData.setPixel(x, y, (buffer[i + 2] & 0xFF) << 16 | (buffer[i + 1] & 0xFF) << 8 | buffer[i] & 0xFF);
                            ++x;
                        }
                        ++y;
                    }
                    return imgData;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

