/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility.io;

import com.arm.streamline.common.CommonPlugin;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class EditorInputUtils {
    public static IEditorInput createWorkspaceInput(File file) {
        return EditorInputUtils.createWorkspaceInput(file.toURI());
    }

    public static IEditorInput createWorkspaceInput(IEditorInput input) {
        IEditorInput result = EditorInputUtils.createWorkspaceInput(EditorInputUtils.getURI(input));
        return result != null ? result : input;
    }

    public static IEditorInput createWorkspaceInput(IEditorInput input, String extension) {
        IEditorInput result = EditorInputUtils.createWorkspaceInput(EditorInputUtils.getURI(input, extension));
        return result != null ? result : input;
    }

    public static IEditorInput createWorkspaceInput(IPath path) {
        return new FileEditorInput(ResourcesPlugin.getWorkspace().getRoot().getFile(path));
    }

    public static IEditorInput createWorkspaceInput(URI uri) {
        URI relativeURI = EditorInputUtils.getWorkspaceURI(uri);
        if (relativeURI != uri) {
            return EditorInputUtils.createWorkspaceInput((IPath)new Path(relativeURI.getPath()));
        }
        try {
            return new FileStoreEditorInput(EFS.getStore((URI)uri));
        }
        catch (CoreException exception) {
            CommonPlugin.error((Throwable)exception);
            return null;
        }
    }

    public static String getExtension(IEditorInput input) {
        return EditorInputUtils.getExtension(EditorInputUtils.getURI(input));
    }

    public static String getExtension(URI uri) {
        String path = uri.toString();
        int last = path.lastIndexOf(46);
        if (last != -1) {
            return path.substring(last);
        }
        return null;
    }

    public static IFileStore getFileStore(IEditorInput input) {
        URI uri = EditorInputUtils.getURI(input);
        if (uri != null) {
            try {
                return EFS.getStore((URI)uri);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getReadableString(IEditorInput input) {
        Path path = EditorInputUtils.getWorkspacePath(input);
        if (path == null) {
            try {
                return EFS.getStore((URI)EditorInputUtils.getURI(input)).toString();
            }
            catch (CoreException exception) {
                CommonPlugin.error((Throwable)exception);
                return "";
            }
        }
        return path.toPortableString();
    }

    public static URI getURI(IEditorInput input) {
        try {
            if (input instanceof IURIEditorInput) {
                return EditorInputUtils.normalizeURI(((IURIEditorInput)input).getURI());
            }
            if (input instanceof IPathEditorInput) {
                return EditorInputUtils.normalizeURI(((IPathEditorInput)input).getPath().toFile().toURI());
            }
            if (input instanceof IStorageEditorInput) {
                return EditorInputUtils.normalizeURI(((IStorageEditorInput)input).getStorage().getFullPath().toFile().toURI());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static URI getURI(IEditorInput input, String extension) {
        URI uri = EditorInputUtils.getURI(input);
        String oldExt = EditorInputUtils.getExtension(uri);
        if (extension.equals(oldExt)) {
            return uri;
        }
        IFileStore fileStore = EditorInputUtils.getFileStore(input);
        if (!fileStore.getFileSystem().isCaseSensitive() && extension.equalsIgnoreCase(oldExt)) {
            return uri;
        }
        Object path = uri.toString();
        path = ((String)path).substring(0, ((String)path).length() - oldExt.length()) + extension;
        try {
            uri = new URI((String)path);
        }
        catch (URISyntaxException exception) {
            CommonPlugin.error((Throwable)exception);
        }
        return uri;
    }

    public static Path getWorkspacePath(IEditorInput input) {
        URI relativeURI;
        URI uri = EditorInputUtils.getURI(input);
        if (uri != null && (relativeURI = EditorInputUtils.getWorkspaceURI(uri)) != uri) {
            return new Path(relativeURI.getPath());
        }
        return null;
    }

    public static URI getWorkspaceURI(IPath path) {
        return EditorInputUtils.getWorkspaceURI(path.toFile().toURI());
    }

    public static URI getWorkspaceURI(URI uri) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = root.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            URI result = project.getLocationURI().relativize(uri);
            if (result != uri) {
                return root.getLocationURI().relativize(uri);
            }
            ++n2;
        }
        return uri;
    }

    public static boolean hasExtension(IEditorInput input, String extension) {
        URI uri = EditorInputUtils.getURI(input);
        String oldExt = EditorInputUtils.getExtension(uri);
        if (extension.equals(oldExt)) {
            return true;
        }
        IFileStore fileStore = EditorInputUtils.getFileStore(input);
        return !fileStore.getFileSystem().isCaseSensitive() && extension.equalsIgnoreCase(oldExt);
    }

    public static boolean isValidFileStoreInput(IEditorInput input) {
        return input instanceof IURIEditorInput || input instanceof IPathEditorInput || input instanceof IStorageEditorInput;
    }

    public static URI normalizeURI(URI uri) {
        File file = new File(uri).getAbsoluteFile();
        Object p = file.getPath();
        if (File.separatorChar != '/') {
            p = ((String)p).replace(File.separatorChar, '/');
        }
        if (!((String)p).startsWith("/")) {
            p = "/" + (String)p;
        }
        if (((String)p).startsWith("//")) {
            p = "//" + (String)p;
        }
        try {
            return new URI("file", null, (String)p, null);
        }
        catch (Exception ex) {
            CommonPlugin.error((Throwable)ex);
            return uri;
        }
    }
}

