/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CharacterConversionOutputStream
extends FilterOutputStream {
    private byte[] mOldChar;
    private byte[] mNewChar;
    private int mPos;

    public CharacterConversionOutputStream(OutputStream stream, char oldChar, char newChar) {
        super(stream);
        StringBuilder buffer = new StringBuilder(2);
        buffer.append(oldChar);
        this.mOldChar = buffer.toString().getBytes();
        buffer.setLength(0);
        buffer.append(newChar);
        this.mNewChar = buffer.toString().getBytes();
    }

    @Override
    public void flush() throws IOException {
        int i = 0;
        while (i < this.mPos) {
            super.write(this.mOldChar[i]);
            ++i;
        }
        super.flush();
    }

    @Override
    public void write(int b) throws IOException {
        if (b == this.mOldChar[this.mPos]) {
            if (++this.mPos < this.mOldChar.length) {
                return;
            }
            byte[] byArray = this.mNewChar;
            int n = this.mNewChar.length;
            int n2 = 0;
            while (n2 < n) {
                byte element = byArray[n2];
                super.write(element);
                ++n2;
            }
            this.mPos = 0;
        } else {
            int i = 0;
            while (i < this.mPos) {
                super.write(this.mOldChar[i]);
                ++i;
            }
            this.mPos = 0;
            super.write(b);
        }
    }
}

