/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility.expression2;

import com.arm.streamline.utility.expression2.ExpressionException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class Tokenizer {
    public static @NonNull List<@NonNull Token> tokenize(@NonNull String expression) throws ExpressionException {
        ArrayList<Token> result = new ArrayList<Token>();
        int length = expression.length();
        int index = 0;
        while (index < length) {
            if (Character.isWhitespace(expression.charAt(index))) {
                ++index;
                continue;
            }
            Token nextToken = Tokenizer.parseNextToken(expression, index, length);
            result.add(nextToken);
            index += nextToken.getToken().length();
        }
        return result;
    }

    private static boolean isIdentifierCharacter(char c) {
        return Tokenizer.isIdentifierPrefix(c) || Tokenizer.isNumeric(c);
    }

    private static boolean isIdentifierPrefix(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_';
    }

    private static boolean isNumeric(char c) {
        return c >= '0' && c <= '9';
    }

    private static @Nullable String parseFunctionName(@NonNull String expression, int from, int limit) {
        boolean hadPrefix = false;
        int index = from;
        while (index < limit) {
            char current = expression.charAt(index);
            if (Tokenizer.isIdentifierPrefix(current)) {
                hadPrefix = true;
                ++index;
                continue;
            }
            if (!hadPrefix) break;
            if (Tokenizer.isIdentifierCharacter(current)) {
                ++index;
                continue;
            }
            if (current != '.' && current != '$') break;
            return null;
        }
        if (index == from || !hadPrefix) {
            return null;
        }
        return expression.substring(from, index);
    }

    private static @NonNull Token parseNextToken(@NonNull String expression, int from, int limit) throws ExpressionException {
        char next;
        char prefix = expression.charAt(from);
        char c = next = from + 1 < limit ? expression.charAt(from + 1) : (char)'\u0000';
        if (prefix == '$') {
            String variable = Tokenizer.parseVariable(expression, from, limit);
            if (variable != null) {
                return new Token(Token.Type.VARIABLE, variable);
            }
        } else if (Tokenizer.isIdentifierPrefix(prefix)) {
            String word = Tokenizer.parseFunctionName(expression, from, limit);
            if (word != null) {
                return new Token(Token.Type.FUNCTION_NAME, word);
            }
        } else if (Tokenizer.isNumeric(prefix) || prefix == '.') {
            String number = Tokenizer.parseNumber(expression, from, limit);
            if (number != null) {
                return new Token(Token.Type.NUMBER, number);
            }
        } else {
            switch (prefix) {
                case '(': {
                    return Token.LPAREN;
                }
                case ')': {
                    return Token.RPAREN;
                }
                case '+': {
                    return Token.PLUS;
                }
                case '-': {
                    return Token.MINUS;
                }
                case '*': {
                    return Token.MULTIPLY;
                }
                case '/': {
                    return Token.DIVIDE;
                }
                case '%': {
                    return Token.MODULO;
                }
                case ',': {
                    return Token.COMMA;
                }
                case '=': {
                    if (next != '=') break;
                    return Token.EQUALS;
                }
                case '&': {
                    if (next != '&') break;
                    return Token.AND;
                }
                case '|': {
                    if (next != '|') break;
                    return Token.OR;
                }
                case '!': {
                    if (next == '=') {
                        return Token.NOT_EQUALS;
                    }
                    return Token.NOT;
                }
                case '<': {
                    if (next == '=') {
                        return Token.LESS_THAN_EQUAL;
                    }
                    return Token.LESS_THAN;
                }
                case '>': {
                    if (next == '=') {
                        return Token.GREATER_THAN_EQUAL;
                    }
                    return Token.GREATER_THAN;
                }
            }
        }
        throw new ExpressionException(ExpressionException.Reason.INVALID_TOKEN, expression.substring(from, limit));
    }

    private static @Nullable String parseNumber(@NonNull String expression, int from, int limit) {
        boolean hadDot = false;
        boolean hadE = false;
        boolean requiresNumeric = false;
        int index = from;
        while (index < limit) {
            char next;
            char current = expression.charAt(index);
            char c = next = index + 1 < limit ? expression.charAt(index + 1) : (char)'\u0000';
            if (Tokenizer.isNumeric(current)) {
                requiresNumeric = false;
                ++index;
                continue;
            }
            if (requiresNumeric) {
                return null;
            }
            if (current == '.') {
                if (hadDot || hadE) {
                    return null;
                }
                if (index == from) {
                    requiresNumeric = true;
                }
                hadDot = true;
                ++index;
                continue;
            }
            if (current == 'E' || current == 'e') {
                if (hadE) {
                    return null;
                }
                hadE = true;
                requiresNumeric = true;
                ++index;
                if (next != '+' && next != '-') continue;
                ++index;
                continue;
            }
            if (current != '$') break;
            return null;
        }
        return index == from || requiresNumeric ? null : expression.substring(from, index);
    }

    private static @Nullable String parseVariable(@NonNull String expression, int from, int limit) {
        boolean hadDollar = false;
        boolean hadAtLeastOneLetter = false;
        boolean requiresPrefixLetter = true;
        int index = from;
        while (index < limit) {
            char current = expression.charAt(index);
            if (current == '$') {
                if (hadDollar) {
                    return null;
                }
                hadDollar = true;
                ++index;
                continue;
            }
            if (!hadDollar) {
                return null;
            }
            if (Tokenizer.isIdentifierPrefix(current)) {
                hadAtLeastOneLetter = true;
                requiresPrefixLetter = false;
                ++index;
                continue;
            }
            if (requiresPrefixLetter) {
                return null;
            }
            if (Tokenizer.isIdentifierCharacter(current)) {
                ++index;
                continue;
            }
            if (current != '.') break;
            requiresPrefixLetter = true;
            ++index;
        }
        if (index == from || requiresPrefixLetter && !hadAtLeastOneLetter) {
            return null;
        }
        return expression.substring(from, index);
    }

    public static final class Token {
        private static final @NonNull Token AND = new Token(Type.OP_AND, "&&");
        private static final @NonNull Token COMMA = new Token(Type.OP_COMMA, ",");
        private static final @NonNull Token DIVIDE = new Token(Type.OP_DIVIDE, "/");
        private static final @NonNull Token EQUALS = new Token(Type.OP_EQUALS, "==");
        private static final @NonNull Token GREATER_THAN = new Token(Type.OP_GREATER_THAN, ">");
        private static final @NonNull Token GREATER_THAN_EQUAL = new Token(Type.OP_GREATER_THAN_EQUAL, ">=");
        private static final @NonNull Token LESS_THAN = new Token(Type.OP_LESS_THAN, "<");
        private static final @NonNull Token LESS_THAN_EQUAL = new Token(Type.OP_LESS_THAN_EQUAL, "<=");
        private static final @NonNull Token LPAREN = new Token(Type.OP_LPAREN, "(");
        private static final @NonNull Token MINUS = new Token(Type.OP_MINUS, "-");
        private static final @NonNull Token MODULO = new Token(Type.OP_MODULO, "%");
        private static final @NonNull Token MULTIPLY = new Token(Type.OP_MULTIPLY, "*");
        private static final @NonNull Token NOT = new Token(Type.OP_NOT, "!");
        private static final @NonNull Token NOT_EQUALS = new Token(Type.OP_NOT_EQUALS, "!=");
        private static final @NonNull Token OR = new Token(Type.OP_OR, "||");
        private static final @NonNull Token PLUS = new Token(Type.OP_PLUS, "+");
        private static final @NonNull Token RPAREN = new Token(Type.OP_RPAREN, ")");
        private final @NonNull String token;
        private final @NonNull Type type;

        Token(@NonNull Type type, @NonNull String token) {
            this.type = type;
            this.token = token;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Token) {
                Token that = (Token)obj;
                return this.type.equals((Object)that.type) && this.token.contentEquals(that.token);
            }
            return false;
        }

        public @NonNull String getToken() {
            return this.token;
        }

        public @NonNull Type getType() {
            return this.type;
        }

        public int hashCode() {
            return this.token.hashCode() * 31 + this.type.hashCode();
        }

        public String toString() {
            return String.format("Token [type=%s, token=%s]", new Object[]{this.type, this.token});
        }

        public static enum Type {
            FUNCTION_NAME,
            NUMBER,
            OP_AND,
            OP_COMMA,
            OP_DIVIDE,
            OP_EQUALS,
            OP_GREATER_THAN,
            OP_GREATER_THAN_EQUAL,
            OP_LESS_THAN,
            OP_LESS_THAN_EQUAL,
            OP_LPAREN,
            OP_MINUS,
            OP_MODULO,
            OP_MULTIPLY,
            OP_NOT,
            OP_NOT_EQUALS,
            OP_OR,
            OP_PLUS,
            OP_RPAREN,
            VARIABLE;

        }
    }
}

