/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility.expression2;

import com.arm.streamline.utility.expression2.ExpressionException;
import com.arm.streamline.utility.expression2.IExpressionNode;
import com.arm.streamline.utility.expression2.IExpressionNodeFactory;
import com.arm.streamline.utility.expression2.Tokenizer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class Parser<T extends IExpressionNode> {
    private int currentIndex = 0;
    private final @NonNull IExpressionNodeFactory<T> factory;
    private final @NonNull List<@NonNull Tokenizer.Token> tokens;

    public static <T extends IExpressionNode> @Nullable T parse(@NonNull IExpressionNodeFactory<T> factory, @NonNull String expression) throws ExpressionException {
        List<Tokenizer.Token> tokens = Tokenizer.tokenize(expression);
        if (tokens.isEmpty()) {
            return null;
        }
        Parser<T> parser = new Parser<T>(factory, tokens);
        return parser.root();
    }

    private Parser(@NonNull IExpressionNodeFactory<T> factory, @NonNull List<@NonNull Tokenizer.Token> tokens) {
        this.factory = factory;
        this.tokens = tokens;
    }

    private @NonNull ExpressionException exception(@NonNull ExpressionException.Reason reason, @Nullable Tokenizer.Token token) {
        return new ExpressionException(reason, this.tokens.stream().map(t -> {
            if (t == token) {
                return String.format("[[ %s ]]", t.getToken());
            }
            return t.getToken();
        }).collect(Collectors.joining(" ", "", "")));
    }

    private @Nullable T expression() throws ExpressionException {
        return this.expressionConsume(0);
    }

    /*
     * Unable to fully structure code
     */
    private @Nullable T expressionConsume(int precedence) throws ExpressionException {
        currentValue = this.value();
        if (currentValue != null) ** GOTO lbl16
        return null;
lbl-1000:
        // 1 sources

        {
            opToken = this.peekToken();
            op = this.takeOperator();
            if (op == null) break;
            if (op.precedence < precedence) {
                if (!Parser.$assertionsDisabled && precedence <= 0) {
                    throw new AssertionError();
                }
                --this.currentIndex;
                return currentValue;
            }
            rhs = this.expressionConsume(op.precedence + 1);
            if (rhs == null) {
                throw this.exception(ExpressionException.Reason.FAILED_TO_PARSE_MISSING_VALUE, opToken);
            }
            currentValue = this.factory.binaryNode(op, currentValue, rhs);
lbl16:
            // 2 sources

            ** while (this.hasToken())
        }
lbl17:
        // 2 sources

        return currentValue;
    }

    private @Nullable T function(@NonNull Tokenizer.Token functionToken) throws ExpressionException {
        Tokenizer.Token token;
        Tokenizer.Token lparam = this.takeToken();
        if (lparam.getType() != Tokenizer.Token.Type.OP_LPAREN) {
            throw this.exception(ExpressionException.Reason.FAILED_TO_PARSE_MISSING_FN_LPAREN, functionToken);
        }
        ArrayList<T> args = new ArrayList<T>();
        boolean requiresValue = false;
        while (true) {
            T arg;
            if ((arg = this.expression()) != null) {
                requiresValue = false;
                args.add(arg);
            }
            if ((token = this.takeToken()).getType() != Tokenizer.Token.Type.OP_COMMA) break;
            if (arg == null) {
                throw this.exception(ExpressionException.Reason.FAILED_TO_PARSE_UNEXPECTED_TOKEN, token);
            }
            requiresValue = true;
        }
        if (token.getType() == Tokenizer.Token.Type.OP_RPAREN) {
            if (requiresValue) {
                throw this.exception(ExpressionException.Reason.FAILED_TO_PARSE_UNEXPECTED_TOKEN, token);
            }
            IExpressionNode.FunctionOp functionOp = IExpressionNode.FunctionOp.map(functionToken.getToken());
            if (functionOp == null) {
                throw this.exception(ExpressionException.Reason.FAILED_TO_PARSE_INVALID_FUNCTION, functionToken);
            }
            if (!functionOp.validArgumentCount(args.size())) {
                throw this.exception(ExpressionException.Reason.FAILED_TO_PARSE_INVALID_FUNCTION_ARGS, functionToken);
            }
            return this.factory.functionNode(functionOp, args);
        }
        throw this.exception(ExpressionException.Reason.FAILED_TO_PARSE_UNEXPECTED_TOKEN, token);
    }

    private boolean hasToken() {
        return this.currentIndex < this.tokens.size();
    }

    private @Nullable Tokenizer.Token peekToken() {
        if (this.hasToken()) {
            return this.tokens.get(this.currentIndex);
        }
        return null;
    }

    private @NonNull T root() throws ExpressionException {
        this.currentIndex = 0;
        T result = this.expression();
        if (result == null || this.hasToken()) {
            throw this.exception(ExpressionException.Reason.FAILED_TO_PARSE_INVALID_EXPRESSION, this.peekToken());
        }
        return result;
    }

    private @Nullable T subExpression(@NonNull Tokenizer.Token lparen) throws ExpressionException {
        T result = this.expression();
        if (result == null) {
            return null;
        }
        Tokenizer.Token nextToken = this.takeToken();
        if (nextToken.getType() != Tokenizer.Token.Type.OP_RPAREN) {
            throw this.exception(ExpressionException.Reason.FAILED_TO_PARSE_UNEXPECTED_TOKEN, nextToken);
        }
        return result;
    }

    private @NonNull IExpressionNode.BinaryOp takenTokenBinaryOpSkip(@NonNull IExpressionNode.BinaryOp op) {
        ++this.currentIndex;
        return op;
    }

    private @Nullable IExpressionNode.BinaryOp takeOperator() throws ExpressionException {
        Tokenizer.Token currentToken = this.peekToken();
        if (currentToken == null) {
            return null;
        }
        switch (currentToken.getType()) {
            case FUNCTION_NAME: 
            case NUMBER: 
            case OP_COMMA: 
            case OP_LPAREN: 
            case OP_NOT: 
            case OP_RPAREN: 
            case VARIABLE: {
                return null;
            }
            case OP_AND: {
                return this.takenTokenBinaryOpSkip(IExpressionNode.BinaryOp.AND);
            }
            case OP_DIVIDE: {
                return this.takenTokenBinaryOpSkip(IExpressionNode.BinaryOp.DIVIDE);
            }
            case OP_EQUALS: {
                return this.takenTokenBinaryOpSkip(IExpressionNode.BinaryOp.EQUALS);
            }
            case OP_GREATER_THAN: {
                return this.takenTokenBinaryOpSkip(IExpressionNode.BinaryOp.GREATER_THAN);
            }
            case OP_GREATER_THAN_EQUAL: {
                return this.takenTokenBinaryOpSkip(IExpressionNode.BinaryOp.GREATER_THAN_EQUAL);
            }
            case OP_LESS_THAN: {
                return this.takenTokenBinaryOpSkip(IExpressionNode.BinaryOp.LESS_THAN);
            }
            case OP_LESS_THAN_EQUAL: {
                return this.takenTokenBinaryOpSkip(IExpressionNode.BinaryOp.LESS_THAN_EQUAL);
            }
            case OP_MINUS: {
                return this.takenTokenBinaryOpSkip(IExpressionNode.BinaryOp.MINUS);
            }
            case OP_MODULO: {
                return this.takenTokenBinaryOpSkip(IExpressionNode.BinaryOp.MODULO);
            }
            case OP_MULTIPLY: {
                return this.takenTokenBinaryOpSkip(IExpressionNode.BinaryOp.MULTIPLY);
            }
            case OP_NOT_EQUALS: {
                return this.takenTokenBinaryOpSkip(IExpressionNode.BinaryOp.NOT_EQUALS);
            }
            case OP_OR: {
                return this.takenTokenBinaryOpSkip(IExpressionNode.BinaryOp.OR);
            }
            case OP_PLUS: {
                return this.takenTokenBinaryOpSkip(IExpressionNode.BinaryOp.PLUS);
            }
        }
        throw new AssertionError(currentToken);
    }

    private @NonNull Tokenizer.Token takeToken() throws ExpressionException {
        if (this.hasToken()) {
            return this.tokens.get(this.currentIndex++);
        }
        throw this.exception(ExpressionException.Reason.FAILED_TO_PARSE_MISSING_TOKEN, null);
    }

    private @Nullable T unaryExpression(@NonNull IExpressionNode.UnaryOp op, @NonNull Tokenizer.Token token) throws ExpressionException {
        T value = this.value();
        if (value == null) {
            throw this.exception(ExpressionException.Reason.FAILED_TO_PARSE_MISSING_VALUE, token);
        }
        return this.factory.unaryNode(op, value);
    }

    private @Nullable T value() throws ExpressionException {
        Tokenizer.Token currentToken = this.peekToken();
        if (currentToken == null) {
            return null;
        }
        switch (currentToken.getType()) {
            case FUNCTION_NAME: {
                return this.function(this.takeToken());
            }
            case NUMBER: {
                return this.factory.numberNode(this.takeToken());
            }
            case VARIABLE: {
                return this.variable(this.takeToken());
            }
            case OP_LPAREN: {
                return this.subExpression(this.takeToken());
            }
            case OP_MINUS: {
                return this.unaryExpression(IExpressionNode.UnaryOp.MINUS, this.takeToken());
            }
            case OP_NOT: {
                return this.unaryExpression(IExpressionNode.UnaryOp.NOT, this.takeToken());
            }
            case OP_PLUS: {
                return this.unaryExpression(IExpressionNode.UnaryOp.PLUS, this.takeToken());
            }
            case OP_AND: 
            case OP_COMMA: 
            case OP_DIVIDE: 
            case OP_EQUALS: 
            case OP_GREATER_THAN: 
            case OP_GREATER_THAN_EQUAL: 
            case OP_LESS_THAN: 
            case OP_LESS_THAN_EQUAL: 
            case OP_MODULO: 
            case OP_MULTIPLY: 
            case OP_NOT_EQUALS: 
            case OP_OR: 
            case OP_RPAREN: {
                return null;
            }
        }
        throw new AssertionError(currentToken);
    }

    private @Nullable T variable(@NonNull Tokenizer.Token variable) throws ExpressionException {
        assert (variable.getType() == Tokenizer.Token.Type.VARIABLE);
        String nameWithoutDollar = variable.getToken().substring(1);
        String[] nameParts = nameWithoutDollar.split("\\.");
        assert (nameParts.length > 0);
        IExpressionNode.BuiltInConstant constant = IExpressionNode.BuiltInConstant.map(nameParts[0]);
        if (constant != null) {
            if (nameParts.length != 1) {
                throw this.exception(ExpressionException.Reason.FAILED_TO_PARSE_INVALID_CONSTANT, variable);
            }
            return this.factory.constant(constant);
        }
        return this.factory.variableNode(nameWithoutDollar);
    }
}

