/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility.expression2;

import com.arm.streamline.utility.expression2.ExpressionException;
import com.arm.streamline.utility.expression2.IExpressionEvaluatorHelper;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public interface IExpressionNode {

    public static enum BinaryOp {
        AND(1){

            @Override
            public double evaluateToNumber(double lhs, double rhs) {
                return lhs != 0.0 && rhs != 0.0 ? 1.0 : 0.0;
            }
        }
        ,
        DIVIDE(5){

            @Override
            public double evaluateToNumber(double lhs, double rhs) {
                return rhs != 0.0 ? lhs / rhs : 0.0;
            }
        }
        ,
        EQUALS(2){

            @Override
            public double evaluateToNumber(double lhs, double rhs) {
                return lhs == rhs ? 1.0 : 0.0;
            }
        }
        ,
        GREATER_THAN(3){

            @Override
            public double evaluateToNumber(double lhs, double rhs) {
                return lhs > rhs ? 1.0 : 0.0;
            }
        }
        ,
        GREATER_THAN_EQUAL(3){

            @Override
            public double evaluateToNumber(double lhs, double rhs) {
                return lhs >= rhs ? 1.0 : 0.0;
            }
        }
        ,
        LESS_THAN(3){

            @Override
            public double evaluateToNumber(double lhs, double rhs) {
                return lhs < rhs ? 1.0 : 0.0;
            }
        }
        ,
        LESS_THAN_EQUAL(3){

            @Override
            public double evaluateToNumber(double lhs, double rhs) {
                return lhs <= rhs ? 1.0 : 0.0;
            }
        }
        ,
        MINUS(4){

            @Override
            public double evaluateToNumber(double lhs, double rhs) {
                return lhs - rhs;
            }
        }
        ,
        MODULO(5){

            @Override
            public double evaluateToNumber(double lhs, double rhs) {
                return lhs % rhs;
            }
        }
        ,
        MULTIPLY(5){

            @Override
            public double evaluateToNumber(double lhs, double rhs) {
                return lhs * rhs;
            }
        }
        ,
        NOT_EQUALS(2){

            @Override
            public double evaluateToNumber(double lhs, double rhs) {
                return lhs != rhs ? 1.0 : 0.0;
            }
        }
        ,
        OR(0){

            @Override
            public double evaluateToNumber(double lhs, double rhs) {
                return lhs != 0.0 || rhs != 0.0 ? 1.0 : 0.0;
            }
        }
        ,
        PLUS(4){

            @Override
            public double evaluateToNumber(double lhs, double rhs) {
                return lhs + rhs;
            }
        };

        public final int precedence;

        private BinaryOp(int precedence) {
            this.precedence = precedence;
        }

        public abstract double evaluateToNumber(double var1, double var3);
    }

    public static enum BuiltInConstant {
        ZOOM("ZOOM"){

            @Override
            public double evaluateToNumber(@NonNull IExpressionEvaluatorHelper helper) {
                return helper.evaluateZoom();
            }
        };

        public final @NonNull String name;

        public static @Nullable BuiltInConstant map(@NonNull String name) {
            BuiltInConstant[] builtInConstantArray = BuiltInConstant.values();
            int n = builtInConstantArray.length;
            int n2 = 0;
            while (n2 < n) {
                BuiltInConstant value = builtInConstantArray[n2];
                if (value.name.equalsIgnoreCase(name)) {
                    return value;
                }
                ++n2;
            }
            return null;
        }

        private BuiltInConstant(String name) {
            this.name = name;
        }

        public abstract double evaluateToNumber(@NonNull IExpressionEvaluatorHelper var1);
    }

    public static enum FunctionOp {
        ABS("abs", 1){

            @Override
            public double evaluateToNumber(double @NonNull [] values) throws ExpressionException {
                if (values.length == 1) {
                    return Math.abs(values[0]);
                }
                throw new ExpressionException(ExpressionException.Reason.INVALID_ARGUMENTS, "Wrong number of arguments given to abs()");
            }
        }
        ,
        CEIL("ceil", 1){

            @Override
            public double evaluateToNumber(double @NonNull [] values) throws ExpressionException {
                if (values.length == 1) {
                    return Math.ceil(values[0]);
                }
                throw new ExpressionException(ExpressionException.Reason.INVALID_ARGUMENTS, "Wrong number of arguments given to ceil()");
            }
        }
        ,
        FLOOR("floor", 1){

            @Override
            public double evaluateToNumber(double @NonNull [] values) throws ExpressionException {
                if (values.length == 1) {
                    return Math.floor(values[0]);
                }
                throw new ExpressionException(ExpressionException.Reason.INVALID_ARGUMENTS, "Wrong number of arguments given to floor()");
            }
        }
        ,
        IF("if", 3){

            @Override
            public double evaluateToNumber(double @NonNull [] values) throws ExpressionException {
                if (values.length == 3) {
                    return values[0] != 0.0 ? values[1] : values[2];
                }
                throw new ExpressionException(ExpressionException.Reason.INVALID_ARGUMENTS, "Wrong number of arguments given to if()");
            }
        }
        ,
        MAX("max", 0){

            @Override
            public double evaluateToNumber(double @NonNull [] values) {
                if (values.length > 0) {
                    double result = values[0];
                    int i = 1;
                    while (i < values.length) {
                        result = Math.max(result, values[i]);
                        ++i;
                    }
                    return result;
                }
                return 0.0;
            }
        }
        ,
        MIN("min", 0){

            @Override
            public double evaluateToNumber(double @NonNull [] values) {
                if (values.length > 0) {
                    double result = values[0];
                    int i = 1;
                    while (i < values.length) {
                        result = Math.min(result, values[i]);
                        ++i;
                    }
                    return result;
                }
                return 0.0;
            }
        }
        ,
        ROUND("round", 1){

            @Override
            public double evaluateToNumber(double @NonNull [] values) throws ExpressionException {
                if (values.length == 1) {
                    return Math.round(values[0]);
                }
                throw new ExpressionException(ExpressionException.Reason.INVALID_ARGUMENTS, "Wrong number of arguments given to round()");
            }
        };

        private final @NonNull String name;
        private final int nArgs;

        public static @Nullable FunctionOp map(@NonNull String name) {
            FunctionOp[] functionOpArray = FunctionOp.values();
            int n = functionOpArray.length;
            int n2 = 0;
            while (n2 < n) {
                FunctionOp value = functionOpArray[n2];
                if (value.name.equalsIgnoreCase(name)) {
                    return value;
                }
                ++n2;
            }
            return null;
        }

        private FunctionOp(String name, int nArgs) {
            this.name = name;
            this.nArgs = nArgs;
        }

        public abstract double evaluateToNumber(double @NonNull [] var1) throws ExpressionException;

        public boolean validArgumentCount(int argCount) {
            if (this.nArgs == 0) {
                return argCount > 0;
            }
            return argCount == this.nArgs;
        }
    }

    public static enum UnaryOp {
        MINUS{

            @Override
            public double evaluateToNumber(double value) {
                return -value;
            }
        }
        ,
        NOT{

            @Override
            public double evaluateToNumber(double value) {
                return value != 0.0 ? 1.0 : 0.0;
            }
        }
        ,
        PLUS{

            @Override
            public double evaluateToNumber(double value) {
                return value;
            }
        };


        public abstract double evaluateToNumber(double var1);
    }
}

