/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility.expression2;

import com.arm.streamline.utility.expression2.ExpressionException;
import com.arm.streamline.utility.expression2.IExpressionEvaluatorHelper;
import com.arm.streamline.utility.expression2.IExpressionNode;
import com.arm.streamline.utility.expression2.IExpressionNodeFactory;
import com.arm.streamline.utility.expression2.Tokenizer;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class ExpressionNodeFactory
implements IExpressionNodeFactory<IBaseExpressionNode> {
    @Override
    public @NonNull IBaseExpressionNode binaryNode(@NonNull IExpressionNode.BinaryOp op, @NonNull IBaseExpressionNode lhs, @NonNull IBaseExpressionNode rhs) {
        return new BinaryNode(op, lhs, rhs);
    }

    @Override
    public @NonNull IBaseExpressionNode constant(@NonNull IExpressionNode.BuiltInConstant constant) throws ExpressionException {
        return new ConstantNode(constant);
    }

    @Override
    public @NonNull IBaseExpressionNode functionNode(@NonNull IExpressionNode.FunctionOp functionOp, @NonNull List<@NonNull IBaseExpressionNode> args) {
        assert (functionOp.validArgumentCount(args.size()));
        return new FunctionNode(functionOp, args);
    }

    @Override
    public @NonNull IBaseExpressionNode numberNode( @NonNull Tokenizer.Token value) throws ExpressionException {
        assert (value.getType() == Tokenizer.Token.Type.NUMBER);
        try {
            return new NumberNode(Double.parseDouble(value.getToken()));
        }
        catch (NumberFormatException e) {
            throw new ExpressionException(ExpressionException.Reason.INVALID_NUMBER, value.getToken());
        }
    }

    @Override
    public @NonNull IBaseExpressionNode unaryNode(@NonNull IExpressionNode.UnaryOp op, @NonNull IBaseExpressionNode value) {
        return new UnaryNode(op, value);
    }

    @Override
    public @NonNull IBaseExpressionNode variableNode(@NonNull String variable) {
        return new VariableNode(variable);
    }

    public static final class BinaryNode
    implements IBaseExpressionNode {
        public final @NonNull IBaseExpressionNode lhs;
        public final @NonNull IExpressionNode.BinaryOp op;
        public final @NonNull IBaseExpressionNode rhs;

        public BinaryNode(@NonNull IExpressionNode.BinaryOp op, @NonNull IBaseExpressionNode lhs, @NonNull IBaseExpressionNode rhs) {
            this.op = op;
            this.lhs = lhs;
            this.rhs = rhs;
        }

        @Override
        public <T, R, E extends Throwable> R accept(@NonNull IBaseExpressionNodeVisitor<T, R, E> visitor, T data) throws E {
            return visitor.binaryOp(data, this.op, this.lhs, this.rhs);
        }

        @Override
        public @Nullable String asSingleSourceNameExpression() {
            return null;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof BinaryNode) {
                BinaryNode that = (BinaryNode)obj;
                return this.lhs.equals(that.lhs) && this.op.equals((Object)that.op) && this.rhs.equals(that.rhs);
            }
            return false;
        }

        public int hashCode() {
            return this.op.hashCode();
        }

        public String toString() {
            return String.format("(%s %s %s)", new Object[]{this.op, this.lhs, this.rhs});
        }

        @Override
        public double evaluateToNumber(@NonNull IExpressionEvaluatorHelper helper) throws ExpressionException {
            return this.op.evaluateToNumber(this.lhs.evaluateToNumber(helper), this.rhs.evaluateToNumber(helper));
        }
    }

    public static final class ConstantNode
    implements IBaseExpressionNode {
        public final @NonNull IExpressionNode.BuiltInConstant constant;

        public ConstantNode(@NonNull IExpressionNode.BuiltInConstant constant) {
            this.constant = constant;
        }

        @Override
        public <T, R, E extends Throwable> R accept(@NonNull IBaseExpressionNodeVisitor<T, R, E> visitor, T data) throws E {
            return visitor.constant(data, this.constant);
        }

        @Override
        public @Nullable String asSingleSourceNameExpression() {
            return null;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ConstantNode) {
                ConstantNode that = (ConstantNode)obj;
                return this.constant.equals((Object)that.constant);
            }
            return false;
        }

        public int hashCode() {
            return this.constant.hashCode();
        }

        public String toString() {
            return String.format("%s", new Object[]{this.constant});
        }

        @Override
        public double evaluateToNumber(@NonNull IExpressionEvaluatorHelper helper) {
            return this.constant.evaluateToNumber(helper);
        }
    }

    public static final class FunctionNode
    implements IBaseExpressionNode {
        public final @NonNull List<@NonNull IBaseExpressionNode> args;
        public final @NonNull IExpressionNode.FunctionOp functionOp;

        public FunctionNode(@NonNull IExpressionNode.FunctionOp functionOp, @NonNull List<@NonNull IBaseExpressionNode> args) {
            this.functionOp = functionOp;
            this.args = args;
        }

        @Override
        public <T, R, E extends Throwable> R accept(@NonNull IBaseExpressionNodeVisitor<T, R, E> visitor, T data) throws E {
            return visitor.function(data, this.functionOp, this.args);
        }

        @Override
        public @Nullable String asSingleSourceNameExpression() {
            return null;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof FunctionNode) {
                FunctionNode that = (FunctionNode)obj;
                return this.functionOp.equals((Object)that.functionOp) && this.args.equals(that.args);
            }
            return false;
        }

        public int hashCode() {
            return this.functionOp.hashCode();
        }

        public String toString() {
            return String.format("%s(%s)", new Object[]{this.functionOp, this.args.stream().map(Object::toString).collect(Collectors.joining(", "))});
        }

        @Override
        public double evaluateToNumber(@NonNull IExpressionEvaluatorHelper helper) throws ExpressionException {
            double[] values = new double[this.args.size()];
            int i = 0;
            while (i < values.length) {
                values[i] = this.args.get(i).evaluateToNumber(helper);
                ++i;
            }
            return this.functionOp.evaluateToNumber(values);
        }
    }

    public static interface IBaseExpressionNode
    extends IExpressionNode {
        public <T, R, E extends Throwable> R accept(@NonNull IBaseExpressionNodeVisitor<T, R, E> var1, T var2) throws E;

        public @Nullable String asSingleSourceNameExpression();

        public double evaluateToNumber(@NonNull IExpressionEvaluatorHelper var1) throws ExpressionException;
    }

    public static interface IBaseExpressionNodeVisitor<T, R, E extends Throwable> {
        public R binaryOp(T var1, @NonNull IExpressionNode.BinaryOp var2, @NonNull IBaseExpressionNode var3, @NonNull IBaseExpressionNode var4) throws E;

        public R constant(T var1, @NonNull IExpressionNode.BuiltInConstant var2) throws E;

        public R function(T var1, @NonNull IExpressionNode.FunctionOp var2, @NonNull List<@NonNull IBaseExpressionNode> var3) throws E;

        public R number(T var1, double var2) throws E;

        public R unaryOp(T var1, @NonNull IExpressionNode.UnaryOp var2, @NonNull IBaseExpressionNode var3) throws E;

        public R variable(T var1, @NonNull String var2) throws E;
    }

    public static final class NumberNode
    implements IBaseExpressionNode {
        public final double value;

        public NumberNode(double value) {
            this.value = value;
        }

        @Override
        public <T, R, E extends Throwable> R accept(@NonNull IBaseExpressionNodeVisitor<T, R, E> visitor, T data) throws E {
            return visitor.number(data, this.value);
        }

        @Override
        public @Nullable String asSingleSourceNameExpression() {
            return null;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof NumberNode) {
                NumberNode that = (NumberNode)obj;
                return this.value == that.value;
            }
            return false;
        }

        public int hashCode() {
            return Double.hashCode(this.value);
        }

        public String toString() {
            return String.format("%s", this.value);
        }

        @Override
        public double evaluateToNumber(@NonNull IExpressionEvaluatorHelper helper) {
            return this.value;
        }
    }

    public static final class UnaryNode
    implements IBaseExpressionNode {
        public final @NonNull IExpressionNode.UnaryOp op;
        public final @NonNull IBaseExpressionNode value;

        public UnaryNode(@NonNull IExpressionNode.UnaryOp op, @NonNull IBaseExpressionNode value) {
            this.op = op;
            this.value = value;
        }

        @Override
        public <T, R, E extends Throwable> R accept(@NonNull IBaseExpressionNodeVisitor<T, R, E> visitor, T data) throws E {
            return visitor.unaryOp(data, this.op, this.value);
        }

        @Override
        public @Nullable String asSingleSourceNameExpression() {
            return null;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof UnaryNode) {
                UnaryNode that = (UnaryNode)obj;
                return this.op.equals((Object)that.op) && this.value.equals(that.value);
            }
            return false;
        }

        public int hashCode() {
            return this.op.hashCode();
        }

        public String toString() {
            return String.format("(%s %s)", new Object[]{this.op, this.value});
        }

        @Override
        public double evaluateToNumber(@NonNull IExpressionEvaluatorHelper helper) throws ExpressionException {
            return this.op.evaluateToNumber(this.value.evaluateToNumber(helper));
        }
    }

    public static final class VariableNode
    implements IBaseExpressionNode {
        public final @NonNull String variable;

        public VariableNode(@NonNull String variable) {
            this.variable = variable;
        }

        @Override
        public <T, R, E extends Throwable> R accept(@NonNull IBaseExpressionNodeVisitor<T, R, E> visitor, T data) throws E {
            return visitor.variable(data, this.variable);
        }

        @Override
        public @Nullable String asSingleSourceNameExpression() {
            return this.variable;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof VariableNode) {
                VariableNode that = (VariableNode)obj;
                return this.variable.contentEquals(that.variable);
            }
            return false;
        }

        public int hashCode() {
            return this.variable.hashCode();
        }

        public String toString() {
            return String.format("%s", this.variable);
        }

        @Override
        public double evaluateToNumber(@NonNull IExpressionEvaluatorHelper helper) throws ExpressionException {
            return helper.evaluateVariable(this.variable);
        }
    }
}

