/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility;

import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.utility.Debug;
import com.arm.streamline.utility.io.EditorInputUtils;
import com.arm.util.NumberUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.IEditorInput;

public class Timing {
    private static final boolean ENABLED = Debug.isFlagSet("STREAMLINE_TIMING");
    private static final PrintStream OUTPUT;
    private static final Map<String, Timing> ANALYZE_CAPTURE_MAP;
    private static final Map<String, Timing> OPEN_REPORT_MAP;
    private static long DISCLOSURE_START;
    private String mTitle;
    private String mPath;
    private DiskUsage mDiskUsage;
    private long mStartTime;

    static {
        ANALYZE_CAPTURE_MAP = new HashMap<String, Timing>();
        OPEN_REPORT_MAP = new HashMap<String, Timing>();
        PrintStream out = null;
        if (ENABLED) {
            out = System.out;
            String path = Debug.getSetting("STREAMLINE_TIMING_FILE");
            if (path != null) {
                try {
                    out = new PrintStream(path);
                }
                catch (FileNotFoundException exception) {
                    out = null;
                }
            }
        }
        OUTPUT = out;
    }

    public static final void endAnalyzeCapture(String path) {
        Timing timing;
        if (ENABLED && (timing = ANALYZE_CAPTURE_MAP.get(path)) != null) {
            timing.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void endDisclosure(String description) {
        if (ENABLED) {
            long stopped = System.currentTimeMillis();
            PrintStream printStream = OUTPUT;
            synchronized (printStream) {
                OUTPUT.print(description);
                OUTPUT.print(": ");
                OUTPUT.print(Double.toString((double)(stopped - DISCLOSURE_START) / 1000.0));
                OUTPUT.println(" seconds");
                OUTPUT.println();
            }
        }
    }

    public static final void endOpenReport(IEditorInput input) {
        Timing timing;
        if (ENABLED && (timing = OPEN_REPORT_MAP.get(new File(EditorInputUtils.getURI(input)).getAbsolutePath())) != null) {
            timing.finish();
        }
    }

    public static final void startAnalyzeCapture(String path) {
        if (ENABLED) {
            ANALYZE_CAPTURE_MAP.put(path, new Timing("[Analyzing a capture]", path, DiskUsage.CAPTURE_ONLY));
        }
    }

    public static final void startDisclosure() {
        if (ENABLED) {
            DISCLOSURE_START = System.currentTimeMillis();
        }
    }

    public static final void startOpenReport(IEditorInput input) {
        if (ENABLED) {
            String path = new File(EditorInputUtils.getURI(input)).getAbsolutePath();
            OPEN_REPORT_MAP.put(path, new Timing("[Opening the report]", path, DiskUsage.REPORT_ONLY));
        }
    }

    private Timing(String title, String path, DiskUsage diskUsage) {
        this.mTitle = title;
        this.mPath = path;
        this.mDiskUsage = diskUsage;
        this.mStartTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish() {
        long stopped = System.currentTimeMillis();
        ArrayList<Object> col1 = new ArrayList<Object>();
        ArrayList<String> col2 = new ArrayList<String>();
        col1.add("Capture Used:");
        col2.add(FilePath.getLeafName((String)this.mPath));
        col1.add("Bytes on disk (" + this.mDiskUsage.getType() + "):");
        long bytes = this.mDiskUsage.getBytes(this.mPath);
        col2.add(bytes >= 0L ? NumberUtils.format((long)bytes) : "unknown");
        col1.add("Seconds to process:");
        col2.add(Double.toString((double)(stopped - this.mStartTime) / 1000.0));
        int max = 0;
        for (String string : col1) {
            int length = string.length();
            if (max >= length) continue;
            max = length;
        }
        ++max;
        int n = col1.size();
        PrintStream printStream = OUTPUT;
        synchronized (printStream) {
            OUTPUT.println(this.mTitle);
            int i = 0;
            while (i < n) {
                OUTPUT.print("    ");
                String one = (String)col1.get(i);
                OUTPUT.print(one);
                int length = one.length();
                while (length < max) {
                    OUTPUT.print(' ');
                    ++length;
                }
                OUTPUT.println((String)col2.get(i));
                ++i;
            }
            OUTPUT.println();
        }
    }

    static class DirectorySizer
    implements FileVisitor<Path> {
        private Path mExclude;
        private long mBytes;

        DirectorySizer(Path exclude) {
            this.mExclude = exclude;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            if (this.mExclude != null && this.mExclude.equals(dir)) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            this.mBytes += attrs.size();
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        long getBytes() {
            return this.mBytes;
        }
    }

    static enum DiskUsage {
        CAPTURE_ONLY{

            @Override
            Path getExclusion(String path) {
                return Paths.get(path, new String[0]).resolve("report");
            }

            @Override
            String getType() {
                return "excluding report";
            }
        }
        ,
        REPORT_ONLY{

            @Override
            Path getExclusion(String path) {
                return null;
            }

            @Override
            String getType() {
                return "report only";
            }
        };


        long getBytes(String path) {
            try {
                DirectorySizer sizer = new DirectorySizer(this.getExclusion(path));
                Files.walkFileTree(Paths.get(path, new String[0]), sizer);
                return sizer.getBytes();
            }
            catch (Exception exception) {
                return -1L;
            }
        }

        abstract Path getExclusion(String var1);

        abstract String getType();
    }
}

