/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility;

import java.io.PrintStream;

public class StatsCollector {
    private static final int DEFAULT_LENGTH = 18;
    private final int[] mCounts;

    public StatsCollector() {
        this(18);
    }

    public StatsCollector(int buckets) {
        this.mCounts = new int[buckets];
    }

    public int collect(int sample) {
        int lastBucketIndex;
        int index = 32 - Integer.numberOfLeadingZeros(sample);
        if (index < (lastBucketIndex = this.mCounts.length - 1)) {
            int n = index;
            this.mCounts[n] = this.mCounts[n] + 1;
            return index;
        }
        int n = lastBucketIndex;
        this.mCounts[n] = this.mCounts[n] + 1;
        return lastBucketIndex;
    }

    public int getCount(int index) {
        return this.mCounts[index];
    }

    public int getBuckets() {
        return this.mCounts.length;
    }

    public void printToStream(PrintStream out) {
        int i = 0;
        while (i < this.mCounts.length - 1) {
            out.printf(" < %8d : %d%n", 1 << i, this.mCounts[i]);
            ++i;
        }
        out.printf("  excessive : %d%n", this.mCounts[this.mCounts.length - 1]);
    }
}

