/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility;

import com.arm.streamline.deviceconn.ssh.ISshCommandRunner;
import com.arm.streamline.deviceconn.ssh.InvalidCredentialException;
import com.arm.streamline.deviceconn.ssh.OpenSSHConfigParser;
import com.arm.streamline.deviceconn.ssh.SshCommandRunner;
import com.arm.streamline.deviceconn.ssh.SshDeviceConfiguration;
import com.arm.streamline.ui.vm.ISshTargetLauncher;
import com.arm.streamline.utility.ISshRunnerFactory;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import java.io.IOException;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public final class SshRunnerFactory
implements ISshRunnerFactory {
    public static final @NonNull SshRunnerFactory SINGLETON = new SshRunnerFactory();

    @Override
    public @NonNull ISshCommandRunner create(@NonNull ISshTargetLauncher launcher) throws IOException, InvalidCredentialException {
        OpenSSHConfigParser.SSHTargetConfig targetConfig = launcher.getSSHTargetConfig();
        String host = targetConfig.hostname();
        int port = targetConfig.port();
        String username = targetConfig.username();
        String password = targetConfig.password();
        List keyFiles = targetConfig.keyFiles();
        SshDeviceConfiguration config = password != null && !password.isEmpty() ? new SshDeviceConfiguration(host, port, username, password) : new SshDeviceConfiguration(host, port, username, keyFiles);
        return new SshCommandRunner(config, null, (TIntIntMap)new TIntIntHashMap());
    }
}

