/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility;

import com.arm.utils.text.BasicNumberUtils;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.RGB;

public class RGBUtils {
    private static final Map<String, String> NAME_TO_RGB = new HashMap<String, String>();
    private static final Map<String, String> RGB_TO_NAME = new HashMap<String, String>();
    public static final RGB BLACK = new RGB(0, 0, 0);
    public static final RGB WHITE = new RGB(255, 255, 255);
    private static final float HUE_START = 50.0f;
    private static final float HUE_END = 10.0f;

    static {
        RGBUtils.add("AliceBlue", "240,248,255");
        RGBUtils.add("AntiqueWhite", "250,235,215");
        RGBUtils.add("Aqua", "0,255,255");
        RGBUtils.add("Aquamarine", "127,255,212");
        RGBUtils.add("Azure", "240,255,255");
        RGBUtils.add("Beige", "245,245,220");
        RGBUtils.add("Bisque", "255,228,196");
        RGBUtils.add("Black", "0,0,0");
        RGBUtils.add("BlanchedAlmond", "255,235,205");
        RGBUtils.add("Blue", "0,0,255");
        RGBUtils.add("BlueViolet", "138,43,226");
        RGBUtils.add("Brown", "165,42,42");
        RGBUtils.add("BurlyWood", "222,184,135");
        RGBUtils.add("CadetBlue", "95,158,160");
        RGBUtils.add("Chartreuse", "127,255,0");
        RGBUtils.add("Chocolate", "210,105,30");
        RGBUtils.add("Coral", "255,127,80");
        RGBUtils.add("CornflowerBlue", "100,149,237");
        RGBUtils.add("Cornsilk", "255,248,220");
        RGBUtils.add("Crimson", "220,20,60");
        RGBUtils.add("Cyan", "0,255,255");
        RGBUtils.add("DarkBlue", "0,0,139");
        RGBUtils.add("DarkCyan", "0,139,139");
        RGBUtils.add("DarkGoldenRod", "184,134,11");
        RGBUtils.add("DarkGray", "169,169,169");
        RGBUtils.add("DarkGrey", "169,169,169");
        RGBUtils.add("DarkGreen", "0,100,0");
        RGBUtils.add("DarkKhaki", "189,183,107");
        RGBUtils.add("DarkMagenta", "139,0,139");
        RGBUtils.add("DarkOliveGreen", "85,107,47");
        RGBUtils.add("Darkorange", "255,140,0");
        RGBUtils.add("DarkOrchid", "153,50,204");
        RGBUtils.add("DarkRed", "139,0,0");
        RGBUtils.add("DarkSalmon", "233,150,122");
        RGBUtils.add("DarkSeaGreen", "143,188,143");
        RGBUtils.add("DarkSlateBlue", "72,61,139");
        RGBUtils.add("DarkSlateGray", "47,79,79");
        RGBUtils.add("DarkSlateGrey", "47,79,79");
        RGBUtils.add("DarkTurquoise", "0,206,209");
        RGBUtils.add("DarkViolet", "148,0,211");
        RGBUtils.add("DeepPink", "255,20,147");
        RGBUtils.add("DeepSkyBlue", "0,191,255");
        RGBUtils.add("DimGray", "105,105,105");
        RGBUtils.add("DimGrey", "105,105,105");
        RGBUtils.add("DodgerBlue", "30,144,255");
        RGBUtils.add("FireBrick", "178,34,34");
        RGBUtils.add("FloralWhite", "255,250,240");
        RGBUtils.add("ForestGreen", "34,139,34");
        RGBUtils.add("Fuchsia", "255,0,255");
        RGBUtils.add("Gainsboro", "220,220,220");
        RGBUtils.add("GhostWhite", "248,248,255");
        RGBUtils.add("Gold", "255,215,0");
        RGBUtils.add("GoldenRod", "218,165,32");
        RGBUtils.add("Gray", "128,128,128");
        RGBUtils.add("Grey", "128,128,128");
        RGBUtils.add("Green", "0,128,0");
        RGBUtils.add("GreenYellow", "173,255,47");
        RGBUtils.add("HoneyDew", "240,255,240");
        RGBUtils.add("HotPink", "255,105,180");
        RGBUtils.add("IndianRed", "205,92,92");
        RGBUtils.add("Indigo", "75,0,130");
        RGBUtils.add("Ivory", "255,255,240");
        RGBUtils.add("Khaki", "240,230,140");
        RGBUtils.add("Lavender", "230,230,250");
        RGBUtils.add("LavenderBlush", "255,240,245");
        RGBUtils.add("LawnGreen", "124,252,0");
        RGBUtils.add("LemonChiffon", "255,250,205");
        RGBUtils.add("LightBlue", "173,216,230");
        RGBUtils.add("LightCoral", "240,128,128");
        RGBUtils.add("LightCyan", "224,255,255");
        RGBUtils.add("LightGoldenRodYellow", "250,250,210");
        RGBUtils.add("LightGray", "211,211,211");
        RGBUtils.add("LightGrey", "211,211,211");
        RGBUtils.add("LightGreen", "144,238,144");
        RGBUtils.add("LightPink", "255,182,193");
        RGBUtils.add("LightSalmon", "255,160,122");
        RGBUtils.add("LightSeaGreen", "32,178,170");
        RGBUtils.add("LightSkyBlue", "135,206,250");
        RGBUtils.add("LightSlateGray", "119,136,153");
        RGBUtils.add("LightSlateGrey", "119,136,153");
        RGBUtils.add("LightSteelBlue", "176,196,222");
        RGBUtils.add("LightYellow", "255,255,224");
        RGBUtils.add("Lime", "0,255,0");
        RGBUtils.add("LimeGreen", "50,205,50");
        RGBUtils.add("Linen", "250,240,230");
        RGBUtils.add("Magenta", "255,0,255");
        RGBUtils.add("Maroon", "128,0,0");
        RGBUtils.add("MediumAquaMarine", "102,205,170");
        RGBUtils.add("MediumBlue", "0,0,205");
        RGBUtils.add("MediumOrchid", "186,85,211");
        RGBUtils.add("MediumPurple", "147,112,219");
        RGBUtils.add("MediumSeaGreen", "60,179,113");
        RGBUtils.add("MediumSlateBlue", "123,104,238");
        RGBUtils.add("MediumSpringGreen", "0,250,154");
        RGBUtils.add("MediumTurquoise", "72,209,204");
        RGBUtils.add("MediumVioletRed", "199,21,133");
        RGBUtils.add("MidnightBlue", "25,25,112");
        RGBUtils.add("MintCream", "245,255,250");
        RGBUtils.add("MistyRose", "255,228,225");
        RGBUtils.add("Moccasin", "255,228,181");
        RGBUtils.add("NavajoWhite", "255,222,173");
        RGBUtils.add("Navy", "0,0,128");
        RGBUtils.add("OldLace", "253,245,230");
        RGBUtils.add("Olive", "128,128,0");
        RGBUtils.add("OliveDrab", "107,142,35");
        RGBUtils.add("Orange", "255,165,0");
        RGBUtils.add("OrangeRed", "255,69,0");
        RGBUtils.add("Orchid", "218,112,214");
        RGBUtils.add("PaleGoldenRod", "238,232,170");
        RGBUtils.add("PaleGreen", "152,251,152");
        RGBUtils.add("PaleTurquoise", "175,238,238");
        RGBUtils.add("PaleVioletRed", "219,112,147");
        RGBUtils.add("PapayaWhip", "255,239,213");
        RGBUtils.add("PeachPuff", "255,218,185");
        RGBUtils.add("Peru", "205,133,63");
        RGBUtils.add("Pink", "255,192,203");
        RGBUtils.add("Plum", "221,160,221");
        RGBUtils.add("PowderBlue", "176,224,230");
        RGBUtils.add("Purple", "128,0,128");
        RGBUtils.add("Red", "255,0,0");
        RGBUtils.add("RosyBrown", "188,143,143");
        RGBUtils.add("RoyalBlue", "65,105,225");
        RGBUtils.add("SaddleBrown", "139,69,19");
        RGBUtils.add("Salmon", "250,128,114");
        RGBUtils.add("SandyBrown", "244,164,96");
        RGBUtils.add("SeaGreen", "46,139,87");
        RGBUtils.add("SeaShell", "255,245,238");
        RGBUtils.add("Sienna", "160,82,45");
        RGBUtils.add("Silver", "192,192,192");
        RGBUtils.add("SkyBlue", "135,206,235");
        RGBUtils.add("SlateBlue", "106,90,205");
        RGBUtils.add("SlateGray", "112,128,144");
        RGBUtils.add("SlateGrey", "112,128,144");
        RGBUtils.add("Snow", "255,250,250");
        RGBUtils.add("SpringGreen", "0,255,127");
        RGBUtils.add("SteelBlue", "70,130,180");
        RGBUtils.add("Tan", "210,180,140");
        RGBUtils.add("Teal", "0,128,128");
        RGBUtils.add("Thistle", "216,191,216");
        RGBUtils.add("Tomato", "255,99,71");
        RGBUtils.add("Turquoise", "64,224,208");
        RGBUtils.add("Violet", "238,130,238");
        RGBUtils.add("Wheat", "245,222,179");
        RGBUtils.add("White", "255,255,255");
        RGBUtils.add("WhiteSmoke", "245,245,245");
        RGBUtils.add("Yellow", "255,255,0");
        RGBUtils.add("YellowGreen", "154,205,50");
    }

    public static final RGB adjust(RGB rgb, float hueAdjustment, float saturationAdjustment, float brightnessAdjustment) {
        float[] hsb = rgb.getHSB();
        if ((hueAdjustment += hsb[0]) < 0.0f) {
            hueAdjustment += (float)((1 - (int)hueAdjustment / 360) * 360);
        }
        if (hueAdjustment >= 360.0f) {
            hueAdjustment %= 360.0f;
        }
        if ((saturationAdjustment += hsb[1]) < 0.0f) {
            saturationAdjustment = 0.0f;
        } else if (saturationAdjustment > 1.0f) {
            saturationAdjustment = 1.0f;
        }
        brightnessAdjustment += hsb[2];
        if (brightnessAdjustment < 0.0f) {
            brightnessAdjustment = 0.0f;
        } else if (brightnessAdjustment > 1.0f) {
            brightnessAdjustment = 1.0f;
        }
        return new RGB(hueAdjustment, saturationAdjustment, brightnessAdjustment);
    }

    public static final RGB blend(RGB first, RGB second, int percentage) {
        return new RGB(RGBUtils.blend(first.red, second.red, percentage), RGBUtils.blend(first.green, second.green, percentage), RGBUtils.blend(first.blue, second.blue, percentage));
    }

    public static final RGB clone(RGB rgb) {
        return new RGB(rgb.red, rgb.green, rgb.blue);
    }

    public static final RGB create(int rgb) {
        return new RGB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
    }

    public static final RGB darken(RGB rgb, int percentage) {
        return RGBUtils.blend(rgb, BLACK, percentage);
    }

    public static final @NonNull RGB decode(String buffer) {
        RGB rgb = new RGB(255, 255, 255);
        RGBUtils.decode(buffer, rgb);
        return rgb;
    }

    public static final void decode(String buffer, RGB rgb) {
        String[] color;
        String value = NAME_TO_RGB.get(((String)(buffer = ((String)buffer).trim())).toLowerCase());
        if (value != null) {
            buffer = value;
        }
        if ((color = ((String)buffer).split(",")).length == 3) {
            rgb.red = BasicNumberUtils.getNonLocalizedInteger((String)color[0], (int)255);
            rgb.green = BasicNumberUtils.getNonLocalizedInteger((String)color[1], (int)255);
            rgb.blue = BasicNumberUtils.getNonLocalizedInteger((String)color[2], (int)255);
        } else if (color.length == 1) {
            int single;
            if (color[0].startsWith("#")) {
                buffer = color[0].substring(1);
                if (((String)buffer).length() == 3) {
                    String ch1 = String.valueOf(((String)buffer).charAt(0));
                    String ch2 = String.valueOf(((String)buffer).charAt(1));
                    String ch3 = String.valueOf(((String)buffer).charAt(2));
                    buffer = ch1 + ch1 + ch2 + ch2 + ch3 + ch3;
                }
                single = BasicNumberUtils.getNonLocalizedHexInteger((String)buffer, (int)0xFFFFFF);
            } else {
                single = BasicNumberUtils.getNonLocalizedInteger((String)color[0], (int)0xFFFFFF);
            }
            rgb.red = single >> 16 & 0xFF;
            rgb.green = single >> 8 & 0xFF;
            rgb.blue = single & 0xFF;
        } else {
            rgb.red = 255;
            rgb.green = 255;
            rgb.blue = 255;
        }
    }

    public static final @NonNull String encode(RGB rgb) {
        String result = rgb.red + "," + rgb.green + "," + rgb.blue;
        String substitute = RGB_TO_NAME.get(result);
        return substitute != null ? substitute : result;
    }

    public static final RGB grayscale(RGB rgb) {
        int luma = RGBUtils.perceivedBrightness(rgb);
        return new RGB(luma, luma, luma);
    }

    public static RGB heat(double percentage) {
        if (percentage < 10.0) {
            return new RGB(50.0f, 0.3f + 0.7f * (float)percentage * 0.1f, 1.0f);
        }
        return new RGB(50.0f + (float)Math.min((int)Math.floor(percentage), 99) * -40.0f * 0.01f, 1.0f, 1.0f);
    }

    public static boolean isDark(RGB rgb) {
        return RGBUtils.perceivedBrightness(rgb) < 128;
    }

    public static boolean isLight(RGB rgb) {
        return RGBUtils.perceivedBrightness(rgb) > 127;
    }

    public static boolean isMonochrome(RGB rgb) {
        return rgb.red == rgb.green && rgb.green == rgb.blue;
    }

    public static final RGB lighten(RGB rgb, int percentage) {
        return RGBUtils.blend(rgb, WHITE, percentage);
    }

    public static int perceivedBrightness(RGB rgb) {
        return (int)Math.sqrt((double)(rgb.red * rgb.red) * 0.21 + (double)(rgb.green * rgb.green) * 0.72 + (double)(rgb.blue * rgb.blue) * 0.07);
    }

    public static final int toInt(int red, int green, int blue) {
        return (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }

    public static final int toInt(RGB rgb) {
        return RGBUtils.toInt(rgb.red, rgb.green, rgb.blue);
    }

    private static final void add(String name, String rgb) {
        NAME_TO_RGB.put(name.toLowerCase(), rgb);
        RGB_TO_NAME.put(rgb, name);
    }

    private static final int blend(int first, int second, int percentage) {
        if (percentage < 1) {
            return first;
        }
        if (percentage > 99) {
            return second;
        }
        int blendedValue = (first * (100 - percentage) + second * percentage) / 100;
        if (blendedValue > 255) {
            return 255;
        }
        if (blendedValue < 0) {
            return 0;
        }
        return blendedValue;
    }
}

