/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility;

import com.arm.streamline.common.xml.counters.Events;
import com.arm.streamline.model.capture.ChartAndSeriesConfig;
import com.arm.streamline.model.templates.TemplateFile;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;

public class GpuTimelineEventsUtil {
    public static final int MIN_DDK_VER = 47;
    public static final String SERIES_NAME = "Mali timeline";

    public static void pruneFromTemplateIfUnsupported(@NonNull Events events, @NonNull TemplateFile template) {
        events.getMaliDdkVersion().flatMap(GpuTimelineEventsUtil::parseIntFromEventsString).filter(ddk -> ddk < 47).ifPresent(__ -> {
            for (ChartAndSeriesConfig chart : template.getCharts()) {
                chart.removeSeriesByName(SERIES_NAME);
            }
        });
    }

    private static Optional<@NonNull Integer> parseIntFromEventsString(@NonNull String s) {
        try {
            int v = Integer.parseInt(s.trim());
            return Optional.of(v);
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }
}

