/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility;

import com.arm.streamline.application.preferences.StreamlinePreferences;
import com.arm.streamline.deviceconn.adb.AdbCommandRunner;
import com.arm.streamline.deviceconn.adb.AdbProcessRunner;
import com.arm.streamline.deviceconn.adb.IAdbCommandRunner;
import com.arm.streamline.deviceconn.adb.IAdbProcessRunner;
import com.arm.streamline.utility.IAdbRunnerCache;
import com.arm.streamline.utility.IAdbRunnerFactory;
import com.arm.utils.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class AdbRunnerFactory
implements IAdbRunnerFactory,
IAdbRunnerCache {
    public static final @NonNull AdbRunnerFactory SINGLETON = new AdbRunnerFactory();
    private final @NonNull Map<@NonNull File, @NonNull IAdbProcessRunner> processRunnerCache = new HashMap<File, IAdbProcessRunner>();
    private final @NonNull Map<@NonNull IAdbProcessRunner, @NonNull Map<@NonNull String, @NonNull IAdbCommandRunner>> commandRunnerCache = new HashMap<IAdbProcessRunner, Map<String, IAdbCommandRunner>>();

    public static boolean isAdbPathSet() {
        File adbPath = StreamlinePreferences.getApplicationPreferences().getAdbPathOrDefault();
        return adbPath != null;
    }

    public static boolean isDefaultAdbValid() {
        File adbFile = StreamlinePreferences.getDefaultAdbPath();
        if (adbFile == null || !adbFile.exists()) {
            return false;
        }
        return AdbProcessRunner.isValidAdb((String)adbFile.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull IAdbProcessRunner create(@NonNull File adbPath) throws IOException {
        File cononicalPath = FileUtils.canonicalise((File)adbPath);
        Map<File, IAdbProcessRunner> map = this.processRunnerCache;
        synchronized (map) {
            IAdbProcessRunner result = this.processRunnerCache.get(cononicalPath);
            if (result == null) {
                result = new AdbProcessRunner(cononicalPath);
                this.processRunnerCache.put(cononicalPath, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull IAdbCommandRunner create(@NonNull IAdbProcessRunner adbProcessRunner, @NonNull String serialNo) throws IOException {
        Map map;
        Map map2 = this.commandRunnerCache;
        synchronized (map2) {
            map = this.commandRunnerCache.computeIfAbsent(adbProcessRunner, k -> new HashMap());
        }
        map2 = map;
        synchronized (map2) {
            IAdbCommandRunner result = (IAdbCommandRunner)map.get(serialNo);
            if (result == null) {
                result = new AdbCommandRunner(adbProcessRunner, serialNo);
                map.put(serialNo, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable IAdbCommandRunner getCommandRunnerForDevice(@NonNull IAdbProcessRunner adbProcessRunner, @NonNull String serialNo) {
        Map<String, IAdbCommandRunner> map;
        Map<Object, Map<String, Object>> map2 = this.commandRunnerCache;
        synchronized (map2) {
            map = this.commandRunnerCache.get(adbProcessRunner);
        }
        if (map == null) {
            return null;
        }
        map2 = map;
        synchronized (map2) {
            return map.get(serialNo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable IAdbCommandRunner updateCacheStateOnDeviceChange(@NonNull IAdbProcessRunner adbProcessRunner, @NonNull String serialNo, boolean retainOrCreateCacheItem) {
        Map map;
        Map map2 = this.commandRunnerCache;
        synchronized (map2) {
            map = this.commandRunnerCache.computeIfAbsent(adbProcessRunner, k -> new HashMap());
        }
        map2 = map;
        synchronized (map2) {
            if (retainOrCreateCacheItem) {
                return map.compute(serialNo, (k, v) -> {
                    if (v != null) {
                        return v;
                    }
                    try {
                        return new AdbCommandRunner(adbProcessRunner, k);
                    }
                    catch (IOException e) {
                        IAdbCommandRunner result = null;
                        return result;
                    }
                });
            }
            map.remove(serialNo);
            return null;
        }
    }
}

