/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.ui.part.lpv;

import com.arm.streamline.analysis.gator.GatorProtocolVerifier;
import com.arm.streamline.analysis.gator.GatorProtocolVersion;
import com.arm.streamline.authentication.TargetAuthentication;
import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.databrowser.TargetAddressString;
import com.arm.streamline.databrowser.browser.BrowseResult;
import com.arm.streamline.databrowser.browser.ConnectionType;
import com.arm.streamline.databrowser.browser.ITargetBrowserAdapter;
import com.arm.streamline.databrowser.browser.ITargetBrowserClient;
import com.arm.streamline.ui.part.lpv.ITargetBrowserModel;
import com.arm.streamline.ui.utils.ObservableUtils;
import com.arm.streamline.ui.vm.ILandingPageAdbPathPreferenceModel;
import com.arm.streamline.ui.vm.ISshTargetLauncher;
import com.arm.streamline.ui.vm.ITcpTargetDevice;
import java.io.File;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ui.services.IDisposable;

public final class TargetBrowserModel
implements ITargetBrowserModel {
    private final @NonNull ObservableSet<@NonNull ConnectionType> activeScanningConnectionTypes = FXCollections.observableSet((Object[])new ConnectionType[0]);
    private final @NonNull IDisposable adbToolPathChangeListener;
    private final @NonNull ObservableList<@NonNull String> failures = FXCollections.observableArrayList();
    private final @NonNull ObservableBooleanValue scanActive = Bindings.isNotEmpty(this.activeScanningConnectionTypes);
    private @Nullable ITargetBrowserAdapter targetBrowserAdapter;
    private final @NonNull ITargetBrowserClient targetBrowserClient;
    private final @NonNull ObservableList<@NonNull ITcpTargetDevice> tcpTargetDevices = FXCollections.observableArrayList();
    private final @NonNull ObservableList<@NonNull ISshTargetLauncher> sshTargetDevices = FXCollections.observableArrayList();

    public TargetBrowserModel(@NonNull ILandingPageAdbPathPreferenceModel adbPathModel, @NonNull BiFunction<@Nullable File, @Nullable Consumer<@NonNull Exception>, @NonNull ITargetBrowserAdapter> adapterFactory) {
        this.targetBrowserClient = new ITargetBrowserClient(){

            @Override
            public void beginBrowse(@NonNull ConnectionType connectionType) {
                TargetBrowserModel.this.activeScanningConnectionTypes.add((Object)connectionType);
            }

            @Override
            public void debugHardwareSearchFailed(@NonNull String reason) {
                if (TargetBrowserModel.this.failures.isEmpty() || !((String)TargetBrowserModel.this.failures.get(TargetBrowserModel.this.failures.size() - 1)).contentEquals(reason)) {
                    TargetBrowserModel.this.failures.add((Object)reason);
                }
            }

            @Override
            public void endBrowse(@NonNull ConnectionType connectionType) {
                TargetBrowserModel.this.activeScanningConnectionTypes.remove((Object)connectionType);
            }

            @Override
            public void foundNewDebugHardware(@NonNull BrowseResult newHardware) {
                TargetDevice dev = new TargetDevice(newHardware);
                if (!TargetBrowserModel.this.tcpTargetDevices.contains((Object)dev)) {
                    TargetBrowserModel.this.tcpTargetDevices.add((Object)dev);
                }
            }

            @Override
            public void removeDebugHardware(@NonNull BrowseResult removeHardware) {
                TargetBrowserModel.this.tcpTargetDevices.remove((Object)new TargetDevice(removeHardware));
            }
        };
        this.adbToolPathChangeListener = ObservableUtils.onChange((ObservableValue)adbPathModel.adbToolPathProperty(), p -> {
            try {
                ITargetBrowserAdapter targetBrowserAdapter;
                this.closeTargetBrowserAdapter();
                this.targetBrowserAdapter = targetBrowserAdapter = (ITargetBrowserAdapter)adapterFactory.apply((File)p, e -> {
                    CommonPlugin.error((Throwable)e);
                    this.closeTargetBrowserAdapter();
                });
                targetBrowserAdapter.create(this.targetBrowserClient);
            }
            catch (Error | RuntimeException e2) {
                throw e2;
            }
            catch (Exception e3) {
                throw new RuntimeException(e3);
            }
        });
        this.sshTargetDevices.addListener((ListChangeListener)new ListChangeListener<ISshTargetLauncher>(){

            public void onChanged(// Could not load outer class - annotation placement on inner may be incorrect
            ListChangeListener.Change<? extends @NonNull ISshTargetLauncher> change) {
                while (change.next()) {
                    if (change.wasRemoved()) {
                        for (ISshTargetLauncher remitem : change.getRemoved()) {
                            TargetAuthentication.removeFromSSHCache(remitem.getTargetAddress());
                        }
                    }
                    if (!change.wasAdded()) continue;
                    for (ISshTargetLauncher addedItem : change.getAddedSubList()) {
                        TargetAuthentication ta = TargetAuthentication.fromSSHTargetLauncher(addedItem);
                        TargetAuthentication.cache(ta);
                    }
                }
            }
        });
    }

    public void canBrowseForDevices(boolean canBrowse) {
        if (this.targetBrowserAdapter != null) {
            this.targetBrowserAdapter.allowBrowisng(canBrowse);
        }
    }

    public void dispose() {
        this.closeTargetBrowserAdapter();
    }

    @Override
    public @NonNull ObservableList<@NonNull String> failuresProperty() {
        return this.failures;
    }

    @Override
    public @NonNull ObservableBooleanValue scanActiveProperty() {
        return this.scanActive;
    }

    @Override
    public @NonNull ObservableList<@NonNull ITcpTargetDevice> tcpTargetDevicesProperty() {
        return this.tcpTargetDevices;
    }

    @Override
    public @NonNull ObservableList<@NonNull ISshTargetLauncher> sshTargetDevicesProperty() {
        return this.sshTargetDevices;
    }

    private void closeTargetBrowserAdapter() {
        ITargetBrowserAdapter targetBrowserAdapter = this.targetBrowserAdapter;
        if (targetBrowserAdapter != null) {
            targetBrowserAdapter.dispose();
            this.targetBrowserAdapter = null;
            this.tcpTargetDevices.clear();
        }
    }

    protected static final class TargetDevice
    implements ITcpTargetDevice {
        private final @NonNull TargetAddressString address;
        private final @NonNull String description;
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull ITcpTargetDevice.Status status;

        protected TargetDevice(@NonNull BrowseResult browseResult) {
            this(browseResult.getTargetAddressString(), browseResult.getVersion(), browseResult.getAvailable());
        }

        protected TargetDevice(@NonNull TargetAddressString address, @NonNull String versionString, boolean available) {
            boolean versionIsOk;
            StringBuilder descriptionBuilder;
            block2: {
                this.address = address;
                descriptionBuilder = new StringBuilder();
                String strippedVersion = versionString.strip();
                versionIsOk = false;
                try {
                    int versionNo = Integer.parseInt(strippedVersion);
                    GatorProtocolVersion versionObject = new GatorProtocolVersion(versionNo);
                    descriptionBuilder.append("Version ").append(versionObject.getVersionString());
                    versionIsOk = GatorProtocolVerifier.isSuitableForLive(versionObject);
                }
                catch (NumberFormatException e) {
                    if (strippedVersion.isBlank()) break block2;
                    descriptionBuilder.append("Version ").append(strippedVersion);
                }
            }
            this.description = descriptionBuilder.toString();
            this.status = !available ? ITcpTargetDevice.Status.UNAVAILABLE_OTHER : (!versionIsOk ? ITcpTargetDevice.Status.UNAVAILABLE_INVALID_VERSION : ITcpTargetDevice.Status.AVAILABLE);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof TargetDevice) {
                TargetDevice that = (TargetDevice)obj;
                return this.address.equals(that.address);
            }
            return false;
        }

        public @NonNull String getDescription() {
            return this.description;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull ITcpTargetDevice.Status getStatus() {
            return this.status;
        }

        public @NonNull String getTargetAddress() {
            return this.address.toString();
        }

        public @NonNull String getTooltip() {
            switch (this.status) {
                case AVAILABLE: {
                    return "The device is available for use";
                }
                case UNAVAILABLE_INVALID_VERSION: {
                    return "The device is detected as using an invalid version of gatord so cannot be used";
                }
                case UNAVAILABLE_OTHER: {
                    return "The device is not supported";
                }
            }
            throw new AssertionError(this.status);
        }

        public int hashCode() {
            return this.address.hashCode();
        }

        public String toString() {
            return String.format("{%s, %s, %s}", this.address, this.description, this.status);
        }
    }
}

