/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.ui.part.lpv;

import com.arm.streamline.ui.vm.ISshTargetLauncher;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;

public final class SshTargetLauncher
implements ISshTargetLauncher {
    private final @NonNull String commandPath;
    private final @NonNull String commandUserName;
    private final @NonNull String commandWorkingDir;
    private final boolean fromDefaults;
    private final @NonNull String gatorPath;
    private final int gatorPort;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull OpenSSHConfigParser.SSHTargetConfig targetConfig;
    boolean commandStopOnExit;

    public static @NonNull String getDefaultGatorPath() {
        return "~/";
    }

    public static int getDefaultGatorPort() {
        return 8080;
    }

    public static boolean isPortValid(int p) {
        return p > 0 && p <= 65535 && p != 8081;
    }

    public static boolean isPortValid(String port) {
        try {
            int p = Integer.parseInt(port);
            return SshTargetLauncher.isPortValid(p);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public SshTargetLauncher(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull OpenSSHConfigParser.SSHTargetConfig targetConfig, @NonNull String commandPath, @NonNull String commandWorkingDir, @NonNull String commandUserName, int gatorPort, @NonNull String gatorPath, boolean commandStopOnExit, boolean fromDefaults) {
        this.targetConfig = targetConfig;
        this.commandPath = commandPath;
        this.commandWorkingDir = commandWorkingDir;
        this.commandUserName = commandUserName;
        this.commandStopOnExit = commandStopOnExit;
        this.gatorPort = gatorPort;
        this.gatorPath = gatorPath;
        this.fromDefaults = fromDefaults;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SshTargetLauncher other = (SshTargetLauncher)obj;
        return Objects.equals(this.commandPath, other.commandPath) && this.commandStopOnExit == other.commandStopOnExit && Objects.equals(this.commandUserName, other.commandUserName) && Objects.equals(this.commandWorkingDir, other.commandWorkingDir) && this.fromDefaults == other.fromDefaults && Objects.equals(this.gatorPath, other.gatorPath) && this.gatorPort == other.gatorPort && Objects.equals(this.targetConfig, other.targetConfig);
    }

    public @NonNull String getCommandPath() {
        return this.commandPath;
    }

    public @NonNull String getCommandUsername() {
        return this.commandUserName;
    }

    public @NonNull String getCommandWorkingDir() {
        return this.commandWorkingDir;
    }

    public @NonNull String getGatorPath() {
        return this.gatorPath;
    }

    public int getGatorPortNumeric() {
        return this.gatorPort;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull OpenSSHConfigParser.SSHTargetConfig getSSHTargetConfig() {
        return this.targetConfig;
    }

    public @NonNull String getTargetAddress() {
        return String.format("%s:%d", this.targetConfig.hostname(), this.getGatorPortNumeric());
    }

    public int hashCode() {
        return Objects.hash(this.commandPath, this.commandStopOnExit, this.commandUserName, this.commandWorkingDir, this.fromDefaults, this.gatorPath, this.gatorPort, this.targetConfig);
    }

    public boolean isCommandStopOnExit() {
        return this.commandStopOnExit;
    }

    public boolean isFromDefaults() {
        return this.fromDefaults;
    }

    public String toString() {
        return this.getTargetAddress();
    }
}

