/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.ui.part.lpv;

import com.arm.streamline.analysis.gator.GatorProtocolVersion;
import com.arm.streamline.databrowser.GatorSendCommandUtility;
import com.arm.streamline.deviceconn.IBasicInteractiveShell;
import com.arm.streamline.deviceconn.ssh.ISshCommandRunner;
import com.arm.streamline.ui.part.lpv.GatordKiller;
import com.arm.streamline.ui.vm.IGatorKiller;
import com.arm.streamline.ui.vm.ISshDeviceModel;
import com.arm.streamline.ui.vm.ISshTargetLauncher;
import com.arm.streamline.ui.vm.ITargetDevice;
import com.arm.streamline.ui.vm.SshDeviceStatus;
import com.arm.streamline.utility.SshRunnerFactory;
import com.arm.utils.NullChecking;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class SshDeviceModel
implements ISshDeviceModel {
    private static final int CHECKING_PERIOD_IN_SECONDS = 10;
    private @Nullable Map<@NonNull ISshTargetLauncher, @NonNull SimpleObjectProperty<SshDeviceStatus>> changeSet = null;
    private @Nullable Thread checkingThread;
    private final @NonNull AtomicReference<ISshTargetLauncher> currentSelectedDevice = new AtomicReference();
    private final @NonNull IGatorKiller gatorKiller = new GatordKiller();
    private final @NonNull Object lock = new Object();
    private @NonNull SimpleObjectProperty<@NonNull SshDeviceStatus> observableStatus = new SimpleObjectProperty((Object)SshDeviceStatus.UNAVAILABLE_UNKNOWN);
    private final @NonNull Map<@NonNull ISshTargetLauncher, @NonNull SimpleObjectProperty<SshDeviceStatus>> statusMap = new HashMap<ISshTargetLauncher, SimpleObjectProperty<SshDeviceStatus>>();
    private boolean stop = false;

    public static @NonNull SshDeviceStatus getOneDeviceStatus(int localPort, @NonNull ISshCommandRunner commandRunner) {
        try {
            GatorProtocolVersion version;
            GatorSendCommandUtility.RunningGatordInfo info = GatorSendCommandUtility.getRunningGatordInformation(localPort);
            if (!info.couldConnect()) {
                if (SshDeviceModel.isGatordProcessRunning(commandRunner)) {
                    return SshDeviceStatus.UNAVAILABLE_GATORD_PROCESS_FOUND;
                }
                return SshDeviceStatus.AVAILABLE;
            }
            String versionString = info.version();
            GatorProtocolVersion gatorProtocolVersion = version = versionString == null ? null : SshDeviceModel.parseVersion(versionString);
            if (versionString == null) {
                return SshDeviceStatus.UNAVAILABLE_NON_GATORD_USING_PORT;
            }
            if (version != null && version.supportsExitOk()) {
                return SshDeviceStatus.UNAVAILABLE_KILLABLE_GATORD_RUNNING;
            }
            return SshDeviceStatus.UNAVAILABLE_UNKILLABLE_GATORD_RUNNING;
        }
        catch (Throwable e) {
            return SshDeviceStatus.UNAVAILABLE_UNKNOWN;
        }
    }

    private static @NonNull SshDeviceStatus getOneDeviceStatus(@NonNull ISshTargetLauncher target) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ISshCommandRunner commandRunner = SshRunnerFactory.SINGLETON.create(target);){
                int port = commandRunner.forwardLocalPort(0, target.getGatorPortNumeric());
                return SshDeviceModel.getOneDeviceStatus(port, commandRunner);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable e) {
            return SshDeviceStatus.UNAVAILABLE_UNKNOWN;
        }
    }

    private static boolean isGatordProcessRunning(@NonNull ISshCommandRunner commandRunner) throws IOException {
        IBasicInteractiveShell.InteractiveCommandResult pgrep = commandRunner.runCommandAndGetOutput("pgrep", new String[]{"-x", "gatord-main"});
        return pgrep.status.isSuccessful();
    }

    private static @Nullable GatorProtocolVersion parseVersion(@NonNull String version) {
        try {
            return new GatorProtocolVersion(Integer.parseInt(version));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.stop = true;
        Object object = this.lock;
        synchronized (object) {
            Thread th = this.checkingThread;
            this.lock.notify();
            if (th != null) {
                th.interrupt();
                this.checkingThread = null;
            }
        }
    }

    public boolean doKillGatordOnDevice(@NonNull ITargetDevice device) {
        return this.gatorKiller.doKillGatordOnDevice(device);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull ObservableValue<SshDeviceStatus> getStatusPropertyFor(@NonNull ISshTargetLauncher target) {
        Object object = this.lock;
        synchronized (object) {
            return (ObservableValue)this.statusMap.computeIfAbsent(target, k -> {
                SimpleObjectProperty result = new SimpleObjectProperty((Object)SshDeviceStatus.UNAVAILABLE_UNKNOWN);
                this.lockedPutChangeSet((ISshTargetLauncher)k, (SimpleObjectProperty<SshDeviceStatus>)result, true);
                return result;
            });
        }
    }

    public @NonNull ObjectProperty<@NonNull SshDeviceStatus> startCheckingDeviceStatuses(@NonNull ObservableList<@NonNull ISshTargetLauncher> availableDevices, @NonNull ObjectProperty<@Nullable ISshTargetLauncher> selectedDevice, final @NonNull Consumer<@NonNull Runnable> runOnUIThread) {
        assert (this.checkingThread == null);
        this.currentSelectedDevice.set((ISshTargetLauncher)selectedDevice.get());
        availableDevices.addListener((ListChangeListener)new ListChangeListener<ISshTargetLauncher>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public void onChanged(// Could not load outer class - annotation placement on inner may be incorrect
            ListChangeListener.Change<? extends @NonNull ISshTargetLauncher> change) {
                var2_2 = SshDeviceModel.this.lock;
                synchronized (var2_2) lbl-1000:
                // 4 sources

                {
                    while (change.next()) {
                        block15: {
                            block14: {
                                if (!change.wasReplaced()) break block14;
                                n = change.getTo() - change.getFrom();
                                i = 0;
                                while (i < n) {
                                    removed = (ISshTargetLauncher)change.getRemoved().get(i);
                                    added = (ISshTargetLauncher)change.getAddedSubList().get(i);
                                    statusProperty = SshDeviceModel.this.statusMap.remove(removed);
                                    if (statusProperty == null) {
                                        if (!SshDeviceModel.$assertionsDisabled) {
                                            throw new AssertionError();
                                        }
                                        statusProperty = new SimpleObjectProperty((Object)SshDeviceStatus.UNAVAILABLE_UNKNOWN);
                                    }
                                    statusProperty.set((Object)SshDeviceStatus.UNAVAILABLE_UNKNOWN);
                                    if (SshDeviceModel.this.currentSelectedDevice.get() == removed || SshDeviceModel.this.currentSelectedDevice.get() == added) {
                                        SshDeviceModel.this.setSelectedStatusFrom((SimpleObjectProperty<SshDeviceStatus>)statusProperty);
                                    }
                                    SshDeviceModel.this.statusMap.put(added, (SimpleObjectProperty<SshDeviceStatus>)statusProperty);
                                    SshDeviceModel.this.lockedPutChangeSet(added, (SimpleObjectProperty<SshDeviceStatus>)statusProperty, false);
                                    ++i;
                                }
                                ** GOTO lbl-1000
                            }
                            if (!change.wasRemoved()) break block15;
                            for (ISshTargetLauncher removed : change.getRemoved()) {
                                statusProperty = SshDeviceModel.this.statusMap.remove(removed);
                                if (statusProperty != null) {
                                    statusProperty.set((Object)SshDeviceStatus.UNAVAILABLE_UNKNOWN);
                                }
                                if (SshDeviceModel.this.currentSelectedDevice.get() != removed) continue;
                                SshDeviceModel.this.setSelectedStatusFrom(SshDeviceStatus.UNAVAILABLE_UNKNOWN);
                            }
                            ** GOTO lbl-1000
                        }
                        if (!change.wasAdded()) continue;
                        for (ISshTargetLauncher added : change.getAddedSubList()) {
                            statusProperty = SshDeviceModel.this.statusMap.computeIfAbsent(added, (Function<ISshTargetLauncher, SimpleObjectProperty>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$0(com.arm.streamline.ui.vm.ISshTargetLauncher ), (Lcom/arm/streamline/ui/vm/ISshTargetLauncher;)Ljavafx/beans/property/SimpleObjectProperty;)());
                            statusProperty.set((Object)SshDeviceStatus.UNAVAILABLE_UNKNOWN);
                            if (SshDeviceModel.this.currentSelectedDevice.get() == added) {
                                SshDeviceModel.this.setSelectedStatusFrom((SimpleObjectProperty<SshDeviceStatus>)statusProperty);
                            }
                            SshDeviceModel.this.lockedPutChangeSet(added, (SimpleObjectProperty<SshDeviceStatus>)statusProperty, false);
                        }
                        ** GOTO lbl-1000
                    }
                    if (SshDeviceModel.this.checkingThread == null) {
                        th = SshDeviceModel.this.checkingThread = new Thread((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$1(java.util.function.Consumer ), ()V)(this, (Consumer)runOnUIThread), "ssh-device-checker");
                        th.setDaemon(true);
                        th.start();
                    } else {
                        SshDeviceModel.this.lock.notify();
                    }
                }
            }

            private static /* synthetic */ SimpleObjectProperty lambda$0(ISshTargetLauncher k) {
                return new SimpleObjectProperty((Object)SshDeviceStatus.UNAVAILABLE_UNKNOWN);
            }

            private /* synthetic */ void lambda$1(Consumer consumer) {
                SshDeviceModel.this.checkContinuously(consumer);
            }
        });
        selectedDevice.addListener((property, oldDevice, newDevice) -> {
            this.currentSelectedDevice.set((ISshTargetLauncher)newDevice);
            if (newDevice == null) {
                this.setSelectedStatusFrom(SshDeviceStatus.UNAVAILABLE_UNKNOWN);
                return;
            }
            if (this.stop) {
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                SimpleObjectProperty statusProperty = this.statusMap.computeIfAbsent((ISshTargetLauncher)newDevice, k -> new SimpleObjectProperty((Object)SshDeviceStatus.UNAVAILABLE_UNKNOWN));
                this.setSelectedStatusFrom((SimpleObjectProperty<SshDeviceStatus>)statusProperty);
                this.lockedPutChangeSet((ISshTargetLauncher)newDevice, (SimpleObjectProperty<SshDeviceStatus>)statusProperty, true);
            }
        });
        return this.observableStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkContinuously(@NonNull Consumer<@NonNull Runnable> runOnUIThread) {
        while (!this.stop) {
            Map<ISshTargetLauncher, SimpleObjectProperty<SshDeviceStatus>> itemsToCheck;
            try {
                Object object = this.lock;
                synchronized (object) {
                    Map<ISshTargetLauncher, SimpleObjectProperty<SshDeviceStatus>> changeSet;
                    while (true) {
                        if ((changeSet = this.takeChangeSet()) != null) break;
                        this.lock.wait(10000L);
                    }
                    itemsToCheck = changeSet;
                }
            }
            catch (InterruptedException e) {
                break;
            }
            for (Map.Entry<ISshTargetLauncher, SimpleObjectProperty<SshDeviceStatus>> entry : itemsToCheck.entrySet()) {
                ISshTargetLauncher currentTarget = entry.getKey();
                SimpleObjectProperty<SshDeviceStatus> currentProperty = entry.getValue();
                SshDeviceStatus status = SshDeviceModel.getOneDeviceStatus(currentTarget);
                try {
                    runOnUIThread.accept(() -> {
                        currentProperty.setValue((Object)status);
                        if (this.currentSelectedDevice.get() == currentTarget) {
                            this.setSelectedStatusFrom(status);
                        }
                    });
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
    }

    private void lockedPutChangeSet(@NonNull ISshTargetLauncher target, @NonNull SimpleObjectProperty<SshDeviceStatus> property, boolean notify) {
        Map<ISshTargetLauncher, SimpleObjectProperty<SshDeviceStatus>> changeSet = this.changeSet;
        if (changeSet == null) {
            this.changeSet = changeSet = new HashMap<ISshTargetLauncher, SimpleObjectProperty<SshDeviceStatus>>();
        }
        changeSet.put(target, property);
        if (notify) {
            this.lock.notify();
        }
    }

    private void setSelectedStatusFrom(@NonNull SimpleObjectProperty<SshDeviceStatus> statusProperty) {
        this.setSelectedStatusFrom((SshDeviceStatus)NullChecking.neverNullOr((Object)((SshDeviceStatus)statusProperty.get()), (Object)SshDeviceStatus.UNAVAILABLE_UNKNOWN));
    }

    private void setSelectedStatusFrom(@NonNull SshDeviceStatus status) {
        this.observableStatus.set((Object)status);
    }

    private @Nullable Map<@NonNull ISshTargetLauncher, @NonNull SimpleObjectProperty<SshDeviceStatus>> takeChangeSet() {
        Map<ISshTargetLauncher, SimpleObjectProperty<SshDeviceStatus>> changeSet = this.changeSet;
        this.changeSet = null;
        if (changeSet != null && !changeSet.isEmpty()) {
            return changeSet;
        }
        return null;
    }
}

