/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.ui.part.lpv;

import com.arm.streamline.databrowser.TargetAddressString;
import com.arm.streamline.deviceconn.adb.AdbDeviceRootMode;
import com.arm.streamline.ui.vm.IAndroidPackage;
import com.arm.streamline.ui.vm.IAndroidTargetLauncher;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class AndroidTargetLauncher
implements IAndroidTargetLauncher {
    private final @NonNull TargetAddressString address;
    private final @NonNull IAndroidPackage selectedPackage;
    private final boolean commandStopOnExit;
    private final @NonNull AdbDeviceRootMode deviceRootMode;

    private AndroidTargetLauncher(@NonNull TargetAddressString address, @NonNull IAndroidPackage selectedPackage, boolean commandStopOnExit, @NonNull AdbDeviceRootMode deviceRootMode) {
        this.address = address;
        this.selectedPackage = selectedPackage;
        this.commandStopOnExit = commandStopOnExit;
        this.deviceRootMode = deviceRootMode;
    }

    public static @Nullable AndroidTargetLauncher create(@NonNull String addressStr, @NonNull IAndroidPackage selectedPackage, boolean commandStopOnExit, @NonNull AdbDeviceRootMode deviceRootMode) {
        TargetAddressString address = new TargetAddressString(addressStr);
        if (!address.isValid()) {
            return null;
        }
        return new AndroidTargetLauncher(address, selectedPackage, commandStopOnExit, deviceRootMode);
    }

    public boolean equals(Object obj) {
        if (obj instanceof AndroidTargetLauncher) {
            AndroidTargetLauncher that = (AndroidTargetLauncher)obj;
            return this.address.equals(that.address);
        }
        return false;
    }

    public @NonNull String getTargetAddress() {
        return this.address.toString();
    }

    public @NonNull IAndroidPackage getDebuggablePackage() {
        return this.selectedPackage;
    }

    public @NonNull String getDeviceSerialNumber() {
        return this.address.getAndroidSerialNumber();
    }

    public int hashCode() {
        return this.address.hashCode();
    }

    public boolean isCommandStopOnExit() {
        return this.commandStopOnExit;
    }

    public @NonNull AdbDeviceRootMode getDeviceRootMode() {
        return this.deviceRootMode;
    }
}

