/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.ui.part.lpv;

import com.arm.streamline.application.actions.ShowPreferencesAction;
import com.arm.streamline.application.preferences.ExternalToolsPage;
import com.arm.streamline.application.preferences.IPreferences;
import com.arm.streamline.application.preferences.StreamlinePreferences;
import com.arm.streamline.ui.utils.ObservableUtils;
import com.arm.streamline.ui.vm.ILandingPageAdbPathPreferenceModel;
import java.io.File;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.WritableValue;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.services.IDisposable;

public final class AdbPathPreferenceModel
implements ILandingPageAdbPathPreferenceModel {
    private static final @NonNull String EMPTY = "";
    private final @NonNull SimpleObjectProperty<@Nullable File> adbPath = new SimpleObjectProperty();
    private final @NonNull SimpleBooleanProperty hasValidAdbToolPathSet = new SimpleBooleanProperty();
    private final @NonNull IPropertyChangeListener propertyChangeListener;
    private final @NonNull IPreferences applicationPreferences;
    private final @NonNull IDisposable adbPathChangeListener;

    public AdbPathPreferenceModel(@NonNull IPreferenceStore preferenceStore, @NonNull IPreferences applicationPreferences) {
        this.applicationPreferences = applicationPreferences;
        this.propertyChangeListener = change -> {
            if ("com.arm.streamline.adb.path".contentEquals(change.getProperty())) {
                this.adbPath.set((Object)applicationPreferences.getAdbPathOrDefault());
            }
        };
        preferenceStore.addPropertyChangeListener(this.propertyChangeListener);
        this.adbPathChangeListener = ObservableUtils.mapValue(this.adbPath, (WritableValue)this.hasValidAdbToolPathSet, f -> f != null && f.isFile() && f.canExecute());
        Display display = Display.getCurrent();
        if (display != null) {
            display.asyncExec(() -> this.adbPath.set((Object)applicationPreferences.getAdbPathOrDefault()));
        } else {
            this.adbPath.set((Object)applicationPreferences.getAdbPathOrDefault());
        }
    }

    public @NonNull ObservableObjectValue<@Nullable File> adbToolPathProperty() {
        return this.adbPath;
    }

    public void doShowAdbPathConfigurationPreference() {
        Display display = Display.getCurrent();
        if (display != null) {
            display.asyncExec(() -> ShowPreferencesAction.run(ExternalToolsPage.ID));
        }
    }

    public @NonNull ObservableBooleanValue hasValidAdbToolPathSetProperty() {
        return this.hasValidAdbToolPathSet;
    }

    public void resetAdbPathToDefault() {
        this.adbPath.set((Object)StreamlinePreferences.getDefaultAdbPath());
        this.applicationPreferences.setAdbPath(EMPTY);
    }
}

