/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.ui.part;

import com.arm.streamline.application.HelpContexts;
import com.arm.streamline.application.preferences.StreamlinePreferences;
import com.arm.streamline.databrowser.DeviceConnectionModel;
import com.arm.streamline.databrowser.IDeviceConnectionModel;
import com.arm.streamline.databrowser.browser.TargetBrowserAdapter;
import com.arm.streamline.ui.part.LandingPageActionHandler;
import com.arm.streamline.ui.part.LandingPageScene;
import com.arm.streamline.ui.part.lpv.AdbPathPreferenceModel;
import com.arm.streamline.ui.part.lpv.AndroidDeviceModel;
import com.arm.streamline.ui.part.lpv.AndroidTargetLauncher;
import com.arm.streamline.ui.part.lpv.SshDeviceModel;
import com.arm.streamline.ui.part.lpv.SshTargetLauncher;
import com.arm.streamline.ui.part.lpv.TargetBrowserModel;
import com.arm.streamline.ui.part.lpv.TcpTargetLauncher;
import com.arm.streamline.ui.vm.IAndroidDeviceModel;
import com.arm.streamline.ui.vm.ILandingPageActionHandler;
import com.arm.streamline.ui.vm.ILandingPageAdbPathPreferenceModel;
import com.arm.streamline.ui.vm.ILandingPageSceneViewModel;
import com.arm.streamline.ui.vm.ISshDeviceModel;
import com.arm.streamline.ui.vm.LandingPageSceneViewModel;
import com.arm.streamline.ui.workbench.FXViewPart;
import com.arm.streamline.utility.AdbRunnerFactory;
import com.arm.utils.NullChecking;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.beans.binding.Bindings;
import javafx.collections.ObservableList;
import javafx.scene.Scene;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public final class LandingPageView
extends FXViewPart
implements IPartListener2,
Listener {
    public static final @NonNull String ID = "streamline.view.LandingPageView";
    private final @NonNull ILandingPageSceneViewModel controller;
    private @Nullable LandingPageScene scene;
    private final @NonNull TargetBrowserModel targetBrowserModel;
    private final @NonNull ILandingPageAdbPathPreferenceModel adbPathModel;
    private final @NonNull AndroidDeviceModel androidDeviceManager;
    private final @NonNull SshDeviceModel sshDeviceModel;
    private final @NonNull AtomicBoolean partVisible;
    private final @NonNull AtomicBoolean notMinimized;

    public LandingPageView() throws PartInitException {
        IDeviceConnectionModel deviceConnectionModel = DeviceConnectionModel.get();
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchBrowserSupport browserSupport = workbench.getBrowserSupport();
        LandingPageActionHandler actionHandler = new LandingPageActionHandler(deviceConnectionModel, (IWorkbenchHelpSystem)NullChecking.neverNull((Object)workbench.getHelpSystem()), (IWebBrowser)NullChecking.neverNull((Object)browserSupport.getExternalBrowser()));
        AdbRunnerFactory adbRunnerFactory = new AdbRunnerFactory();
        this.partVisible = new AtomicBoolean(true);
        this.notMinimized = new AtomicBoolean(true);
        this.adbPathModel = new AdbPathPreferenceModel(StreamlinePreferences.getPreferenceStore(), StreamlinePreferences.getApplicationPreferences());
        this.androidDeviceManager = new AndroidDeviceModel(adbRunnerFactory);
        this.sshDeviceModel = new SshDeviceModel();
        this.controller = new LandingPageSceneViewModel((ILandingPageActionHandler)actionHandler, deviceConnectionModel.hasActiveConnectionProperty(), SshTargetLauncher::new, TcpTargetLauncher::create, AndroidTargetLauncher::create, (IAndroidDeviceModel)this.androidDeviceManager, (ISshDeviceModel)this.sshDeviceModel, this.adbPathModel);
        this.targetBrowserModel = new TargetBrowserModel(this.adbPathModel, TargetBrowserAdapter::new);
        Bindings.bindContent((List)this.controller.getTcpSubViewViewModel().detectedDevicesProperty(), this.targetBrowserModel.tcpTargetDevicesProperty());
        Bindings.bindContent(this.targetBrowserModel.sshTargetDevicesProperty(), (ObservableList)this.controller.getSshSubViewViewModel().detectedDevicesProperty());
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().addPartListener((IPartListener2)this);
        Shell currentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        currentShell.addListener(19, (Listener)this);
        currentShell.addListener(20, (Listener)this);
    }

    void updateDeviceManagerBrowsing() {
        this.androidDeviceManager.canBrowseForDevices(this.partVisible.get() && this.notMinimized.get());
        this.targetBrowserModel.canBrowseForDevices(this.partVisible.get() && this.notMinimized.get());
    }

    public void dispose() {
        this.targetBrowserModel.dispose();
        this.androidDeviceManager.dispose();
        this.sshDeviceModel.dispose();
        super.dispose();
    }

    protected @NonNull Scene createFxScene() {
        assert (this.scene == null);
        try {
            LandingPageScene scene;
            this.scene = scene = new LandingPageScene(this.controller, true, true);
            return scene.getScene();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        LandingPageScene scene = this.scene;
        if (scene != null) {
            scene.addListenersToScene();
        }
    }

    protected @Nullable String getHelpId() {
        return HelpContexts.LANDING_PAGE_CONTEXT_ID;
    }

    protected void setFxFocus() {
        LandingPageScene scene = this.scene;
        if (scene != null) {
            scene.getScene().getRoot().requestFocus();
        }
    }

    public void partHidden(IWorkbenchPartReference partRef) {
        if (ID.matches(partRef.getId())) {
            this.partVisible.set(false);
            this.updateDeviceManagerBrowsing();
        }
    }

    public void partVisible(IWorkbenchPartReference partRef) {
        if (ID.matches(partRef.getId())) {
            this.partVisible.set(true);
            this.updateDeviceManagerBrowsing();
        }
    }

    public void handleEvent(Event e) {
        switch (e.type) {
            case 19: {
                this.notMinimized.set(false);
                this.updateDeviceManagerBrowsing();
                break;
            }
            case 20: {
                this.notMinimized.set(true);
                this.updateDeviceManagerBrowsing();
                break;
            }
        }
    }
}

