/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.section;

import com.arm.streamline.performanceadvisor.capturedata.Frame;
import com.arm.streamline.performanceadvisor.section.Element;
import com.arm.streamline.performanceadvisor.section.ElementType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public class PartialColumnList
extends Element {
    private @NonNull List<@NonNull String> columnTitles = new ArrayList<String>();
    private @NonNull List<double[]> columns = new ArrayList<double[]>();
    private @NonNull List<@NonNull Frame> frames = new ArrayList<Frame>();
    private int startFrameIndex = 0;
    private final @NonNull String columnPrefix;

    public PartialColumnList(@NonNull String prefix) {
        super(ElementType.CSV);
        this.columnPrefix = prefix;
        this.setExcludeFromCsv(false);
        this.setExcludeFromHtml(true);
        this.setExcludeFromJson(true);
    }

    public void setFrames(@NonNull List<@NonNull Frame> frames) {
        this.frames = frames;
    }

    public @NonNull List<@NonNull Frame> getFrames() {
        return Collections.unmodifiableList(this.frames);
    }

    public void addColumn(@NonNull String title, double[] data) {
        this.columnTitles.add(this.columnPrefix + " : " + title);
        this.columns.add(data);
    }

    public void setStartFrameIndex(int startFrameIndex) {
        this.startFrameIndex = startFrameIndex;
    }

    public int getStartFrameIndex() {
        return this.startFrameIndex;
    }

    public @NonNull List<double[]> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public @NonNull List<@NonNull String> getColumnTitles() {
        return Collections.unmodifiableList(this.columnTitles);
    }
}

