/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.section;

import com.arm.streamline.performanceadvisor.json.Diffable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class JsonLineMetric
implements Diffable<JsonLineMetric, JsonLineMetric> {
    private Double average;
    private Double max;
    private Double min;
    private Map<Integer, Double> centiles;

    public JsonLineMetric(double[] data, int[] centilesToCalculate) {
        this.centiles = new HashMap<Integer, Double>();
        this.setAverage(data);
        this.setMin(data);
        this.setMax(data);
        this.setCentiles(data, centilesToCalculate);
    }

    public JsonLineMetric(double[] data, int[] centilesToCalculate, double yAverageValue) {
        this(data, centilesToCalculate);
        this.average = yAverageValue;
    }

    public JsonLineMetric(List<double[]> data, int[] centilesToCalculate) {
        this(data.stream().flatMapToDouble(Arrays::stream).toArray(), centilesToCalculate);
    }

    public JsonLineMetric(List<double[]> data, int[] centilesToCalculate, double yAverageValue) {
        this.centiles = new HashMap<Integer, Double>();
        this.average = yAverageValue;
        double[] summedData = JsonLineMetric.aggregateData(data);
        this.setMin(summedData);
        this.setMax(summedData);
        this.setCentiles(summedData, centilesToCalculate);
    }

    public JsonLineMetric(Double average, Double max, Double min, Map<Integer, Double> centiles) {
        this.average = average;
        this.max = max;
        this.min = min;
        this.centiles = centiles;
    }

    private static double[] aggregateData(List<double[]> data) {
        ArrayList<Double> aggregate = new ArrayList<Double>();
        for (double[] values : data) {
            double sum = Arrays.stream(values).sum();
            aggregate.add(sum);
        }
        return aggregate.stream().mapToDouble(Double::doubleValue).toArray();
    }

    private void setAverage(double[] data) {
        this.average = Arrays.stream(data).average().getAsDouble();
    }

    private void setMin(double[] data) {
        this.min = Arrays.stream(data).min().getAsDouble();
    }

    private void setMax(double[] data) {
        this.max = Arrays.stream(data).max().getAsDouble();
    }

    private void setCentiles(double[] data, int[] centilesToCalculate) {
        int[] nArray = centilesToCalculate;
        int n = centilesToCalculate.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            this.centiles.put(i, JsonLineMetric.setPercentile(data, i));
            ++n2;
        }
    }

    private static Double setPercentile(double[] data, int percentile) {
        if (percentile < 1 || percentile > 100) {
            throw new IllegalArgumentException("Invalid percentile");
        }
        double[] sortData = Arrays.copyOf(data, data.length);
        Arrays.sort(sortData);
        int index = (int)Math.ceil((double)percentile / 100.0 * (double)data.length);
        return sortData[index - 1];
    }

    public double getAverage() {
        return this.average;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public Map<Integer, Double> getCentiles() {
        return this.centiles;
    }

    private Map<Integer, Double> diffCentiles(Map<Integer, Double> otherCentiles) {
        if (!this.centiles.keySet().equals(otherCentiles.keySet())) {
            throw new IllegalArgumentException("Centiles keys do not match, cannot do diff.");
        }
        HashMap<Integer, Double> centilesDifference = new HashMap<Integer, Double>();
        for (Map.Entry<Integer, Double> entry : this.centiles.entrySet()) {
            int centile = entry.getKey();
            double value = entry.getValue();
            Double otherValue = otherCentiles.get(centile);
            if (otherValue == null) continue;
            centilesDifference.put(centile, value - otherValue);
        }
        return centilesDifference;
    }

    @Override
    public JsonLineMetric diff(JsonLineMetric other) {
        double averageDiff = this.average - other.average;
        double maxDiff = this.max - other.max;
        double minDiff = this.min - other.min;
        return new JsonLineMetric(averageDiff, maxDiff, minDiff, this.diffCentiles(other.centiles));
    }

    public String toString() {
        return "JsonLineMetric [average=" + String.valueOf(this.average) + ", max=" + String.valueOf(this.max) + ", min=" + String.valueOf(this.min) + ", centiles=" + String.valueOf(this.centiles) + "]";
    }

    public int hashCode() {
        return Objects.hash(this.average, this.centiles, this.max, this.min);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JsonLineMetric)) {
            return false;
        }
        JsonLineMetric other = (JsonLineMetric)obj;
        return Objects.equals(this.average, other.average) && Objects.equals(this.centiles, other.centiles) && Objects.equals(this.max, other.max) && Objects.equals(this.min, other.min);
    }
}

