/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.report;

import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.common.FatalError;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.io.UserProvidedPath;
import com.arm.streamline.performanceadvisor.report.ConfigSectionSpecFactory;
import com.arm.streamline.performanceadvisor.report.GroupDefinition;
import com.arm.streamline.performanceadvisor.report.GroupSpec;
import com.arm.streamline.performanceadvisor.report.Report;
import com.arm.streamline.performanceadvisor.report.ReportDefinition;
import com.arm.streamline.performanceadvisor.report.ReportDefinitionFileReader;
import com.arm.streamline.performanceadvisor.report.SectionDefinition;
import com.arm.streamline.performanceadvisor.report.SectionSpec;
import com.arm.streamline.performanceadvisor.report.StandardSectionSpec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class StandardReport
extends Report {
    private UserProvidedPath defnFilePath;
    private ReportDefinition reportDefn;
    private ReportDefinitionFileReader reportDefnFile;
    private ConfigSectionSpecFactory sectionSpecFactory;

    public StandardReport(String name, UserProvidedPath defnFilePath) {
        super(name);
        this.defnFilePath = defnFilePath;
        this.sectionSpecFactory = new ConfigSectionSpecFactory();
        this.reportDefnFile = new ReportDefinitionFileReader();
    }

    @Override
    public ProblemList prepareForInitialise(CaptureData captureData) {
        ProblemList problemList = new ProblemList();
        this.reportDefn = this.reportDefnFile.read(this.defnFilePath);
        if (this.reportDefn == null) {
            throw new FatalError("Invalid custom report definition: " + String.valueOf(this.defnFilePath.getUserProvidedPath()));
        }
        String pathStr = this.defnFilePath.toString();
        Application.LOG.fine(() -> "Loaded report definition file: " + pathStr);
        List<SectionDefinition> chartList = this.reportDefn.getCharts();
        Application.LOG.fine(() -> String.format("%d custom charts were requested", chartList.size()));
        chartList.stream().forEach(c -> Application.LOG.fine(c.getChartName()));
        if (chartList.isEmpty()) {
            problemList.addError("No charts were found in the report definition file", "Specify a list of charts to include in the report");
            return problemList;
        }
        boolean missingChartNameAndSeriesData = chartList.stream().anyMatch(c -> c.getChartName().isEmpty() && c.getSeries().isEmpty());
        if (missingChartNameAndSeriesData) {
            problemList.addError("One or more charts do not contain a chart name or a series with some expression", "Ensure all sections specify a chart by its name or through a list of series with expressions.");
            return problemList;
        }
        List names = chartList.stream().flatMap(c -> StandardReport.getAllChartNames(c).stream()).collect(Collectors.toList());
        int numDistinct = new HashSet(names).size();
        if (names.size() != numDistinct) {
            problemList.addError("Duplicate chart name found in the report definition file", "Ensure chart names are not repeated");
            return problemList;
        }
        return problemList;
    }

    private static List<String> getAllChartNames(SectionDefinition defn) {
        ArrayList<String> names = new ArrayList<String>();
        if (!defn.getChartName().equals("")) {
            names.add(defn.getChartName());
        }
        names.addAll(defn.getChartAliases());
        return names;
    }

    @Override
    protected List<SectionSpec> createAnalyserList(List<Integer> validUserRegions) {
        ArrayList<SectionSpec> analysers = new ArrayList<SectionSpec>();
        analysers.add(new StandardSectionSpec("Header"));
        for (Integer I : validUserRegions) {
            int i = I;
            analysers.add(new StandardSectionSpec("Summary", i));
            if (i == 0) {
                analysers.add(new StandardSectionSpec("RegionSummary"));
                analysers.add(new StandardSectionSpec("FrameDisplay"));
                analysers.add(new StandardSectionSpec("FpsBoundness"));
            }
            for (GroupDefinition g : this.reportDefn.getGroups()) {
                analysers.add(new GroupSpec(g, i));
                for (SectionDefinition s : g.getCharts()) {
                    analysers.add(this.sectionSpecFactory.create(s, i));
                }
            }
        }
        analysers.add(new StandardSectionSpec("Footer"));
        return analysers;
    }
}

