/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.report;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;

public class ReportDefinitionGson {
    private ReportDefinitionGson() {
        throw new IllegalStateException("CustomReportDefinitionGson should not be instantiated");
    }

    public static Gson build() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapterFactory((TypeAdapterFactory)new OptionalTypeAdapterFactory());
        builder.registerTypeHierarchyAdapter(List.class, (Object)new ListSerializer());
        return builder.create();
    }

    public static class ListSerializer
    implements JsonSerializer<List<?>> {
        public JsonElement serialize(List<?> list, Type type, JsonSerializationContext context) {
            JsonArray array = null;
            if (!list.isEmpty()) {
                array = new JsonArray();
                for (Object i : list) {
                    array.add(context.serialize(i));
                }
            }
            return array;
        }
    }

    public static class OptionalTypeAdapter<T>
    extends TypeAdapter<Optional<T>> {
        private TypeAdapter<T> adapterForUnderlyingType;

        public OptionalTypeAdapter(TypeAdapter<T> adapterForUnderlyingType) {
            this.adapterForUnderlyingType = adapterForUnderlyingType;
        }

        public Optional<T> read(JsonReader in) throws IOException {
            Optional<Object> out = Optional.empty();
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Object v = this.adapterForUnderlyingType.read(in);
                assert (v != null);
                out = Optional.of(v);
            }
            return out;
        }

        public void write(JsonWriter out, Optional<T> value) throws IOException {
            if (value == null || !value.isPresent()) {
                out.nullValue();
            } else {
                this.adapterForUnderlyingType.write(out, value.get());
            }
        }
    }

    public static class OptionalTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            if (typeToken.getRawType() != Optional.class) {
                return null;
            }
            Type type = typeToken.getType();
            Object underlyingType = type instanceof ParameterizedType ? ((ParameterizedType)type).getActualTypeArguments()[0] : Object.class;
            TypeAdapter adapterForUnderlyingType = gson.getAdapter(TypeToken.get(underlyingType));
            return new OptionalTypeAdapter(adapterForUnderlyingType);
        }
    }
}

