/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.report;

import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.analyser.AnalyserLibrary;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.capturedata.Region;
import com.arm.streamline.performanceadvisor.common.LogUtils;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.common.Profiler;
import com.arm.streamline.performanceadvisor.report.SectionSpec;
import com.arm.streamline.performanceadvisor.section.Section;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public abstract class Report {
    private List<SectionSpec> analyserList = Collections.emptyList();
    private final String name;

    protected abstract List<SectionSpec> createAnalyserList(List<Integer> var1);

    public Report(String name) {
        this.name = name;
    }

    public final ProblemList initialise(CaptureData captureData, AnalyserLibrary library, boolean progress) {
        ProblemList problems = this.prepareForInitialise(captureData);
        if (!problems.hasError()) {
            ArrayList<Integer> regions = new ArrayList<Integer>();
            Optional<Integer> maxRegionDepth = captureData.getOptions().getMaximumRegionDepth();
            int i = 0;
            while (i < captureData.getClippedRegionsProvider().getClippedRegions().size()) {
                Region region = captureData.getClippedRegionsProvider().getClippedRegions().get(i);
                if (maxRegionDepth.isPresent()) {
                    if (region.getStackLevel() < maxRegionDepth.get()) {
                        regions.add(i);
                    }
                } else {
                    regions.add(i);
                }
                ++i;
            }
            this.analyserList = this.createAnalyserList(regions);
            Application.LOG.info(() -> String.format("%s contains %d analysers", this.name, this.analyserList.size()));
            int count = 0;
            for (SectionSpec i2 : this.analyserList) {
                if (progress) {
                    count = LogUtils.renderProgress(count, this.analyserList.size());
                }
                Application.LOG.info(() -> String.format("Initialise %s analyser %s", this.name, i2.getName()));
                Instant startTime = Instant.now();
                problems.addAll(library.initialise(i2, captureData));
                Instant endTime = Instant.now();
                Application.PROFILER.record(i2.getName(), Profiler.Phase.INIT, this.name, Duration.between(startTime, endTime));
            }
            if (progress) {
                System.out.println();
            }
        }
        return problems;
    }

    public ProblemList prepareForInitialise(CaptureData captureData) {
        return new ProblemList();
    }

    public final List<Section> execute(AnalyserLibrary library, boolean progress) {
        Application.LOG.info(() -> this.name + ".execute()");
        ArrayList<Section> output = new ArrayList<Section>();
        int count = 0;
        for (SectionSpec i : this.analyserList) {
            if (progress) {
                count = LogUtils.renderProgress(count, this.analyserList.size());
            }
            Instant startTime = Instant.now();
            Section section = library.execute(i, i.getRegion());
            Instant endTime = Instant.now();
            Application.PROFILER.record(i.getName(), Profiler.Phase.EXEC, this.name, Duration.between(startTime, endTime));
            Application.LOG.fine(() -> String.format("%s analyser %s produced %d output elements", this.name, i.getName(), section.size()));
            if (section.size() <= 0) continue;
            output.add(section);
        }
        if (progress) {
            System.out.println();
        }
        Application.LOG.info(() -> String.format("%s contains %d sections", this.name, output.size()));
        return output;
    }
}

