/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.report;

import com.arm.streamline.performanceadvisor.io.UserProvidedPath;
import com.arm.streamline.performanceadvisor.renderer.CsvRenderer;
import com.arm.streamline.performanceadvisor.renderer.Renderer;
import com.arm.streamline.performanceadvisor.renderer.RendererOptions;
import com.arm.streamline.performanceadvisor.report.Report;
import com.arm.streamline.performanceadvisor.report.ReportHandler;
import com.arm.streamline.performanceadvisor.report.StandardReport;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CsvReportHandler
extends ReportHandler {
    private @Nullable UserProvidedPath mDefinitionFilePath;
    private static final @NonNull String REPORT_TYPE_CSV = "csv";

    public CsvReportHandler() {
        super(REPORT_TYPE_CSV);
    }

    public CsvReportHandler(@NonNull UserProvidedPath definitionFilePath) {
        super(REPORT_TYPE_CSV);
        this.mDefinitionFilePath = definitionFilePath;
    }

    @Override
    public @NonNull Report createReport() {
        return new StandardReport(REPORT_TYPE_CSV, this.mDefinitionFilePath);
    }

    @Override
    public @NonNull Renderer createRenderer(RendererOptions rendererOptions) {
        return new CsvRenderer();
    }

    @Override
    public @NonNull String getDescription() {
        return "CSV Per frame report";
    }

    @Override
    public @NonNull String getDefaultFilename() {
        return this.defaultBasename() + ".csv";
    }
}

