/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.report;

import com.arm.streamline.performanceadvisor.report.ChartAndSeriesSectionSpec;
import com.arm.streamline.performanceadvisor.report.ExpressionSectionSpec;
import com.arm.streamline.performanceadvisor.report.FixedFunctionSectionSpec;
import com.arm.streamline.performanceadvisor.report.SectionDefinition;
import com.arm.streamline.performanceadvisor.report.SectionSpec;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ConfigSectionSpecFactory {
    private Map<String, String> fixedNames = new LinkedHashMap<String, String>();

    public ConfigSectionSpecFactory() {
        this.fixedNames.put("CPU cycles [PA]", "cpuCycles");
        this.fixedNames.put("GPU cycles [PA]", "gpuUsage");
        this.fixedNames.put("Shader cycles [PA]", "shaderCore");
        this.fixedNames.put("Draw calls [PA]", "drawCalls");
        this.fixedNames.put("Vertices [PA]", "vertices");
        this.fixedNames.put("Primitives [PA]", "primitives");
        this.fixedNames.put("Pixels [PA]", "pixels");
        this.fixedNames.put("GPU bandwidth [PA]", "gpuBandwidth");
        this.fixedNames.put("Overdraw [PA]", "overdraw");
    }

    public SectionSpec create(SectionDefinition defn, int userRegion) {
        String chartName = defn.getChartName();
        if (this.fixedNames.containsKey(chartName)) {
            String analyserName = this.fixedNames.get(chartName);
            return new FixedFunctionSectionSpec(analyserName, userRegion);
        }
        if (defn.getSeries().isEmpty()) {
            return new ChartAndSeriesSectionSpec(defn, userRegion);
        }
        return new ExpressionSectionSpec(defn, userRegion);
    }

    public List<String> getFixedAnalyserNames() {
        return new ArrayList<String>(this.fixedNames.keySet());
    }
}

