/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.renderer;

import com.arm.streamline.performanceadvisor.capturedata.Frame;
import com.arm.streamline.performanceadvisor.section.PartialColumnList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public class CsvTable {
    private final @NonNull List<@NonNull PartialColumnList> columnList = new ArrayList<PartialColumnList>();

    public CsvTable(@NonNull List<@NonNull PartialColumnList> columnList) {
        if (columnList.isEmpty()) {
            throw new IllegalArgumentException("Expected at least one list of csv data");
        }
        this.columnList.addAll(columnList);
    }

    public @NonNull List<@NonNull String> getColumnTitles() {
        @NonNull ArrayList<@NonNull String> titles = new ArrayList<String>();
        for (PartialColumnList colList : this.columnList) {
            titles.addAll(colList.getColumnTitles());
        }
        return Collections.unmodifiableList(titles);
    }

    public @NonNull List<double[]> getColumns() {
        @NonNull ArrayList<double[]> data = new ArrayList<double[]>();
        for (PartialColumnList colList : this.columnList) {
            data.addAll(colList.getColumns());
        }
        return Collections.unmodifiableList(data);
    }

    public @NonNull List<@NonNull Frame> getFrames() {
        return this.columnList.get(0).getFrames();
    }

    public int getStartFrameIndex() {
        return this.columnList.get(0).getStartFrameIndex();
    }
}

