/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.renderer;

import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.capturedata.Frame;
import com.arm.streamline.performanceadvisor.common.FatalError;
import com.arm.streamline.performanceadvisor.common.LogicError;
import com.arm.streamline.performanceadvisor.renderer.CsvTable;
import com.arm.streamline.performanceadvisor.renderer.CsvTableBuilder;
import com.arm.streamline.performanceadvisor.renderer.Renderer;
import com.arm.streamline.performanceadvisor.section.ElementType;
import com.arm.streamline.performanceadvisor.section.PartialColumnList;
import com.arm.streamline.performanceadvisor.section.Section;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CsvRenderer
implements Renderer {
    @Override
    public void render(@NonNull List<@NonNull Section> sections, @NonNull Path destination) throws RuntimeException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (@NonNull FileOutputStream outputStream = new FileOutputStream(destination.toFile());){
                this.render(sections, outputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Application.LOG.severe(e.getMessage());
            throw new FatalError("Error when encoding report to CSV.");
        }
    }

    public void render(@NonNull List<@NonNull Section> sections, @NonNull OutputStream outputStream) throws IOException {
        @NonNull List<@NonNull PartialColumnList> columnLists = CsvRenderer.getPartialColumnLists(sections);
        if (columnLists.isEmpty()) {
            Application.LOG.warning(() -> "There is no data to write to CSV report file");
            return;
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (@NonNull BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));){
            @NonNull CsvTable reportTable = CsvRenderer.extractCsvTable(columnLists);
            CsvRenderer.writeStringCell(writer, "Per Frame Values");
            writer.write("\n\n");
            CsvRenderer.writeStringCell(writer, "Frame index");
            writer.write(", ");
            CsvRenderer.writeStringCell(writer, "Frame start time (s)");
            writer.write(", ");
            CsvRenderer.writeStringCell(writer, "Frame duration (ms)");
            CsvRenderer.writeColumnTitles(writer, reportTable);
            CsvRenderer.writeColumns(writer, reportTable);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void writeStringCell(@NonNull Writer writer, @NonNull String value) throws IOException {
        writer.write("\"");
        writer.write(value);
        writer.write("\"");
    }

    private static void writeColumns(@NonNull Writer writer, @NonNull CsvTable reportTable) throws IOException {
        @NonNull List<double[]> columns = reportTable.getColumns();
        @NonNull List<@NonNull Frame> frames = reportTable.getFrames();
        int startFrameIndex = reportTable.getStartFrameIndex();
        int row = 0;
        while (row < frames.size()) {
            writer.write(Integer.toString(startFrameIndex + row + 1));
            writer.write(", ");
            @NonNull Frame frame = frames.get(row);
            writer.write(CsvRenderer.convertToSeconds(frame.getStart()));
            writer.write(", ");
            writer.write(CsvRenderer.getFrameDuration(frame));
            for (double[] data : columns) {
                writer.write(", ");
                writer.write(Double.toString(data[row]));
            }
            writer.write("\n");
            ++row;
        }
    }

    private static void writeColumnTitles(@NonNull Writer writer, @NonNull CsvTable reportTable) throws IOException {
        @NonNull List<@NonNull String> titles = reportTable.getColumnTitles();
        for (String title : titles) {
            writer.write(", ");
            CsvRenderer.writeStringCell(writer, title);
        }
        writer.write("\n");
    }

    private static @NonNull CsvTable extractCsvTable(@NonNull List<@NonNull PartialColumnList> columnLists) {
        @NonNull CsvTableBuilder csvTableBuilder = new CsvTableBuilder();
        for (PartialColumnList columnList : columnLists) {
            csvTableBuilder.append(columnList);
        }
        return csvTableBuilder.build();
    }

    private static @NonNull List<@NonNull PartialColumnList> getPartialColumnLists(@NonNull List<@NonNull Section> sections) {
        @NonNull ArrayList<@NonNull T> reportTables = new ArrayList();
        for (Section section : sections) {
            List filteredElements = section.getElements().stream().filter(e -> !e.getExcludeFromCsv()).filter(e -> e.getElementType() == ElementType.CSV).filter(e -> e instanceof PartialColumnList).collect(Collectors.toList());
            if (filteredElements.size() > 1) {
                throw new LogicError("Each section must have exactly one partial column list");
            }
            List partialColumnList = filteredElements.stream().map(element -> (PartialColumnList)element).collect(Collectors.toList());
            reportTables.addAll(partialColumnList);
        }
        return Collections.unmodifiableList(reportTables);
    }

    private static @Nullable String convertToSeconds(int timeInMs) {
        BigDecimal bd = BigDecimal.valueOf(timeInMs);
        bd = bd.divide(BigDecimal.valueOf(1000L));
        @NonNull DecimalFormat df = new DecimalFormat("#0.000");
        return df.format(bd);
    }

    private static @Nullable String getFrameDuration(@NonNull Frame frame) {
        BigDecimal bd = BigDecimal.valueOf(frame.getDrawTime());
        @NonNull DecimalFormat df = new DecimalFormat("#0.000");
        return df.format(bd);
    }
}

