/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.json;

import com.arm.streamline.performanceadvisor.json.Diffable;
import com.arm.streamline.performanceadvisor.section.DualAxisChartJson;
import java.util.ArrayList;
import java.util.List;

public class JsonSection
implements Diffable<JsonSection, JsonSection> {
    private String name;
    private List<DualAxisChartJson> elements;

    public JsonSection(String name, List<DualAxisChartJson> elements) {
        this.name = name;
        this.elements = elements;
    }

    public String getName() {
        return this.name;
    }

    public List<DualAxisChartJson> getElements() {
        return this.elements;
    }

    public String toString() {
        return "JsonSection [name=" + this.name + ", elements=" + String.valueOf(this.elements) + "]";
    }

    @Override
    public JsonSection diff(JsonSection other) {
        if (!this.name.equals(other.name)) {
            throw new IllegalArgumentException("Section names do not match");
        }
        ArrayList<DualAxisChartJson> elementsDiff = new ArrayList<DualAxisChartJson>();
        int i = 0;
        while (i < this.elements.size()) {
            DualAxisChartJson thisElement = this.elements.get(i);
            DualAxisChartJson otherElement = other.elements.get(i);
            DualAxisChartJson diffElement = thisElement.diff(otherElement);
            elementsDiff.add(diffElement);
            ++i;
        }
        return new JsonSection(this.name, elementsDiff);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.elements == null ? 0 : this.elements.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JsonSection other = (JsonSection)obj;
        if (this.elements == null ? other.elements != null : !this.elements.equals(other.elements)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

