/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.json;

import com.arm.streamline.performanceadvisor.json.CaptureInfo;
import com.arm.streamline.performanceadvisor.json.CaptureInfoDiff;
import com.arm.streamline.performanceadvisor.json.Diffable;
import com.arm.streamline.performanceadvisor.json.JsonDiffReport;
import com.arm.streamline.performanceadvisor.json.JsonRegionSection;
import com.arm.streamline.performanceadvisor.json.JsonSection;
import java.util.ArrayList;
import java.util.List;

public class JsonReport
implements Diffable<JsonDiffReport, JsonReport> {
    private List<JsonSection> sections;
    private List<JsonRegionSection> regions;
    private CaptureInfo captureInfo;

    public JsonReport(List<JsonSection> sections, List<JsonRegionSection> regions, CaptureInfo captureInfo) {
        this.sections = sections;
        this.regions = regions;
        this.captureInfo = captureInfo;
    }

    public List<JsonSection> getSections() {
        return this.sections;
    }

    public List<JsonRegionSection> getRegions() {
        return this.regions;
    }

    @Override
    public JsonDiffReport diff(JsonReport other) {
        ArrayList<JsonSection> sectionsDiff = new ArrayList<JsonSection>();
        int i = 0;
        while (i < this.sections.size()) {
            JsonSection thisSection = this.sections.get(i);
            JsonSection otherSection = other.sections.get(i);
            JsonSection diffSection = thisSection.diff(otherSection);
            sectionsDiff.add(diffSection);
            ++i;
        }
        ArrayList<JsonRegionSection> regionsDiff = null;
        if (this.regions != null) {
            regionsDiff = new ArrayList<JsonRegionSection>();
            int i2 = 0;
            while (i2 < this.regions.size()) {
                JsonRegionSection thisRegionSection = this.regions.get(i2);
                JsonRegionSection otherRegionSection = other.regions.get(i2);
                JsonRegionSection diffSection = thisRegionSection.diff(otherRegionSection);
                regionsDiff.add(diffSection);
                ++i2;
            }
        }
        CaptureInfoDiff captureInfoDiff = this.captureInfo.diff(other.captureInfo);
        if (regionsDiff == null) {
            return new JsonDiffReport(sectionsDiff, null, captureInfoDiff);
        }
        return new JsonDiffReport(sectionsDiff, regionsDiff, captureInfoDiff);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.regions == null ? 0 : this.regions.hashCode());
        result = 31 * result + (this.sections == null ? 0 : this.sections.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JsonReport other = (JsonReport)obj;
        if (this.regions == null ? other.regions != null : !this.regions.equals(other.regions)) {
            return false;
        }
        return !(this.sections == null ? other.sections != null : !this.sections.equals(other.sections));
    }

    public String toString() {
        return "JsonReport [sections=" + String.valueOf(this.sections) + ", regions=" + String.valueOf(this.regions) + "]";
    }
}

