/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.json;

import com.arm.streamline.performanceadvisor.io.FileWriterFactory;
import com.arm.streamline.performanceadvisor.io.IFileWriterFactory;
import com.arm.streamline.performanceadvisor.io.JsonFilesWriter;
import com.arm.streamline.performanceadvisor.io.UserProvidedPath;
import com.arm.streamline.performanceadvisor.json.JsonDiffReport;
import com.arm.streamline.performanceadvisor.json.JsonDiffReportSerialiser;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

public class JsonDiffReportFileWriter {
    private boolean prettyPrint;

    public void write(UserProvidedPath path, JsonDiffReport jsonDiffReport) {
        this.write(path, jsonDiffReport, new FileWriterFactory());
    }

    public void write(UserProvidedPath path, JsonDiffReport jsonDiffReport, IFileWriterFactory fileWriterFactory) {
        JsonFilesWriter.write(this.buildGson(), path, jsonDiffReport, fileWriterFactory);
    }

    private Gson buildGson() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(JsonDiffReport.class, (Object)new JsonDiffReportSerialiser());
        if (this.prettyPrint) {
            gsonBuilder.setPrettyPrinting();
        }
        return gsonBuilder.create();
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }
}

