/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.io;

import com.arm.streamline.performanceadvisor.Application;
import java.nio.file.Path;
import java.nio.file.Paths;

public class PlatformUtils {
    private PlatformUtils() {
        throw new IllegalStateException("PlatformUtils should not be instantiated");
    }

    public static Path adjustPathForMacWorkingDirectory(Path path) {
        if (path != null && PlatformUtils.isMacPlatform()) {
            Path cwd = PlatformUtils.getCwd().toAbsolutePath();
            path = cwd.resolve(path).normalize();
        }
        return path;
    }

    public static Path getCwd() {
        String pwd = null;
        try {
            if (PlatformUtils.isMacPlatform()) {
                pwd = System.getenv("PWD");
            }
        }
        catch (Exception e) {
            Application.LOG.severe("Failed to get platform name: " + e.getMessage());
        }
        return pwd == null ? Paths.get("", new String[0]) : Paths.get(pwd, new String[0]);
    }

    public static boolean isMacPlatform() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.contains("mac") || osName.contains("darwin");
    }
}

