/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.io;

import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.common.FatalError;
import com.arm.streamline.performanceadvisor.io.IFileWriterFactory;
import com.arm.streamline.performanceadvisor.io.UserProvidedPath;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;

public class JsonFilesWriter {
    private JsonFilesWriter() {
        throw new IllegalStateException("JsonFilesWriter should not be instantiated");
    }

    public static <T> void write(Gson gson, UserProvidedPath path, T object, IFileWriterFactory fileWriterFactory) {
        Application.LOG.info(() -> "Saving json file to " + String.valueOf(path));
        Path adjustedPath = path.getAdjustedPath();
        Path userPath = path.getUserProvidedPath();
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (Writer writer = fileWriterFactory.createWriter(adjustedPath);){
                writer.write(gson.toJson(object));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new FatalError("Failed to write to " + userPath.toString(), e);
        }
    }
}

