/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.io;

import com.arm.streamline.performanceadvisor.io.PathValidator;
import com.arm.streamline.performanceadvisor.io.UserProvidedPath;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;

public class FileWritePathValidator
extends PathValidator {
    public FileWritePathValidator(UserProvidedPath path) {
        super(path);
    }

    @Override
    Optional<String> validate(UserProvidedPath path) {
        Path adjustedPath = path.getAdjustedPath();
        Path userPath = path.getUserProvidedPath();
        if (Files.isDirectory(adjustedPath, new LinkOption[0])) {
            return Optional.of(String.format("Output file \"%s\" must not be a directory", userPath));
        }
        if (Files.exists(adjustedPath, new LinkOption[0])) {
            if (!Files.isWritable(adjustedPath)) {
                return Optional.of(String.format("No permission to overwrite existing file \"%s\"", userPath));
            }
        } else {
            Path outputPathParent = adjustedPath.toAbsolutePath().getParent();
            if (Files.isRegularFile(outputPathParent, new LinkOption[0])) {
                return Optional.of(String.format("Cannot write to \"%s\". Directory already exists as a file.", userPath));
            }
            if (!Files.isWritable(outputPathParent)) {
                return Optional.of(String.format("No permission to write to \"%s\"", userPath));
            }
        }
        return Optional.empty();
    }
}

