/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.io;

import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.common.FatalError;
import com.arm.streamline.performanceadvisor.io.UserProvidedPath;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.osgi.framework.Bundle;

public class FileUtils {
    private FileUtils() {
        throw new IllegalStateException("FileUtils should not be instantiated");
    }

    public static boolean isSameFile(java.nio.file.Path file, java.nio.file.Path otherFile) throws IOException {
        java.nio.file.Path fileAbsolutePath = file.toAbsolutePath();
        java.nio.file.Path otherFileAbsolutePath = otherFile.toAbsolutePath();
        return Files.isSameFile(fileAbsolutePath, otherFileAbsolutePath);
    }

    public static boolean createMissingDirectoriesForNewFile(java.nio.file.Path destination) {
        java.nio.file.Path parent;
        boolean success = false;
        if (destination != null && (parent = destination.getParent()) != null) {
            try {
                if (Files.notExists(parent, new LinkOption[0])) {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                success = true;
            }
            catch (IOException ioException) {
                Application.LOG.severe("Failed to create directory " + String.valueOf(parent));
                Application.LOG.severe(ioException.getMessage());
            }
        }
        return success;
    }

    public static void createMissingDirectories(UserProvidedPath filePath) {
        if (!FileUtils.createMissingDirectoriesForNewFile(filePath.getAdjustedPath())) {
            String errorMsg = "Failed to create directory " + String.valueOf(filePath.getUserProvidedPath()) + ". Please check you have permissions and the path is correct.";
            throw new FatalError(errorMsg);
        }
    }

    public static boolean fileExists(String filename) throws URISyntaxException, IOException {
        URL url;
        if (filename == null) {
            return false;
        }
        if (Files.exists(Paths.get(filename, new String[0]), new LinkOption[0]) || new File(filename).isFile()) {
            return true;
        }
        String resourceFilename = filename.startsWith("/") ? filename.substring(1) : filename;
        Bundle bundle = Platform.getBundle((String)"com.arm.streamline");
        if (bundle != null && (url = FileLocator.find((Bundle)bundle, (IPath)new Path(resourceFilename), null)) != null && (url = FileLocator.toFileURL((URL)url)) != null) {
            File file = URIUtil.toFile((URI)URIUtil.toURI((URL)url));
            return file != null && file.exists();
        }
        return false;
    }
}

