/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.developer;

import com.arm.streamline.performanceadvisor.analyser.Analyser;
import com.arm.streamline.performanceadvisor.analyser.AnalyserFactory;
import com.arm.streamline.performanceadvisor.analyser.BinnedData;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.capturedata.FpsProvider;
import com.arm.streamline.performanceadvisor.section.DualAxisLineChart;
import com.arm.streamline.performanceadvisor.section.Element;
import com.arm.streamline.performanceadvisor.section.Section;
import com.arm.streamline.performanceadvisor.section.TextBlock;
import com.arm.streamline.performanceadvisor.section.TextStyle;
import java.util.ArrayList;
import java.util.DoubleSummaryStatistics;

public class DualAxisTestAnalyserFactory
extends AnalyserFactory {
    @Override
    public Analyser create(CaptureData captureData) {
        return new DualAxisTestAnalyser(captureData);
    }

    static DualAxisLineChart newExampleChart(BinnedData data, boolean threshold) {
        double xdataStart = data.getTimes()[0];
        int xdataLength = data.getTimes().length;
        double xdataStep = data.getBinDurationMs();
        DualAxisLineChart chart = new DualAxisLineChart("Time (s)", xdataStart, xdataLength, xdataStep, "FPS", data.getSeries(3), "overall");
        int i = 0;
        while (i < data.getNumSeries() - 1) {
            chart.addSeries(data.getName(i), data.getSeries(i), data.getDataPerFrameForSeries(i));
            ++i;
        }
        chart.setYAxisLabel("Cycles");
        DoubleSummaryStatistics stats = data.getSeriesStats(0);
        chart.setYAxisLimit(stats.getMax());
        chart.setY2AxisLimit(70.0);
        if (threshold) {
            chart.setThreshold(stats.getAverage(), "Cycles budget");
        }
        chart.scaleForSiPrefix();
        return chart;
    }

    public class DualAxisTestAnalyser
    extends Analyser {
        public DualAxisTestAnalyser(CaptureData captureData) {
            super(captureData);
        }

        @Override
        public Section execute(int userRegion) {
            assert (userRegion == 0);
            ArrayList<Element> elements = new ArrayList<Element>();
            elements.add(new TextBlock(TextStyle.H2_HIDDEN, "DualAxisLineChart element test", "This chart shows the distribution of GPU cycles across JS1 (vertex/tiler/compute) and JS0 (fragment) work queues. It can serve two purposes. Firstly you can identify the dominant workload, so you know whether to focus on optimizing non-fragment workloads or fragment workloads. Secondly you can see, for regions below target frame rate, whether you are getting overlap across the two work queues. Overlap helps to load balance the shader core resources, and lack of overlap can indicate scheduling bubbles caused by e.g. bad barriers or stage dependencies in Vulkan. Note that overlap is not always possible in regions which are hitting target frame rate."));
            FpsProvider fpsProvider = this.captureData.getFpsProvider();
            double[] fps = fpsProvider.getPerBin().toArray();
            int samplesPerSecond = this.captureData.getSamplesPerSecond();
            BinnedData binnedData = new BinnedData(200, samplesPerSecond, 0.0);
            binnedData.addSeries(fps, "FPS", false);
            ArrayList<double[]> inList = new ArrayList<double[]>();
            inList.add(fps);
            binnedData.addDataPerFrame(inList);
            elements.add(new TextBlock(TextStyle.DESCRIPTION, "Without a threshold line:"));
            elements.add(DualAxisTestAnalyserFactory.newExampleChart(binnedData, false));
            elements.add(new TextBlock(TextStyle.DESCRIPTION, "With a threshold line:"));
            elements.add(DualAxisTestAnalyserFactory.newExampleChart(binnedData, true));
            return new Section("graphTest", elements);
        }
    }
}

