/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.counterseries;

import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.counterseries.BasicSeries;
import com.arm.streamline.performanceadvisor.counterseries.CounterSeries;
import java.lang.ref.SoftReference;
import java.util.function.DoubleUnaryOperator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class UnaryOpSeries
extends BasicSeries {
    private @Nullable SoftReference<double @NonNull []> cachedResult;
    private final @NonNull DoubleUnaryOperator fn;
    private final @NonNull CounterSeries series;

    public UnaryOpSeries(@NonNull CounterSeries series, @NonNull DoubleUnaryOperator fn) {
        this(series, series.getName(), fn);
    }

    public UnaryOpSeries(@NonNull CounterSeries series, @NonNull String name, @NonNull DoubleUnaryOperator fn) {
        super(name);
        this.series = series;
        this.fn = fn;
        Application.LOG.fine(() -> String.format("New UnaryOpSeries %s containing CounterSeries \"%s\"", name, series.getName()));
    }

    @Override
    public int getLength() {
        return this.series.getLength();
    }

    @Override
    public ProblemList initialise(CaptureData captureData) {
        return this.series.initialise(captureData);
    }

    @Override
    public boolean isPerFrame() {
        return this.series.isPerFrame();
    }

    @Override
    public boolean isPresent() {
        return this.series.isPresent();
    }

    @Override
    public double @NonNull [] toArray() {
        return UnaryOpSeries.cacheValue(this.cachedResult, r -> {
            SoftReference softReference = this.cachedResult = r;
        }, () -> {
            double[] d = this.series.toArray();
            double[] result = new double[d.length];
            int i = 0;
            while (i < d.length) {
                result[i] = this.fn.applyAsDouble(d[i]);
                ++i;
            }
            return result;
        });
    }
}

