/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.counterseries;

import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.common.LogicError;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.counterseries.BasicSeries;
import com.arm.streamline.performanceadvisor.counterseries.CounterDescriptor;
import com.arm.streamline.performanceadvisor.counterseries.CounterSeries;
import com.arm.streamline.performanceadvisor.counterseries.StreamlineSeries;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class SummationSeries
extends BasicSeries {
    private boolean anyPresent;
    private @Nullable SoftReference<double @NonNull []> cachedResult;
    private final @NonNull List<@NonNull CounterSeries> counters;
    private boolean initialised;
    private int numSamples;

    public SummationSeries(@NonNull String name) {
        this(name, new ArrayList<CounterSeries>());
    }

    public SummationSeries(@NonNull String name, @NonNull List<@NonNull CounterSeries> counters) {
        super(name);
        this.counters = counters;
        this.numSamples = 0;
        this.initialised = false;
        this.anyPresent = false;
    }

    public void addComponent(@NonNull CounterDescriptor counter) {
        this.addComponent(new StreamlineSeries(counter));
    }

    public void addComponent(@NonNull CounterSeries source) {
        if (this.initialised) {
            throw new LogicError("SummationSeries: add all components before initialisation");
        }
        this.counters.add(source);
    }

    public void addOptionalComponent(@NonNull CounterDescriptor counter) {
        this.addComponent(new StreamlineSeries(counter, true, false));
    }

    @Override
    public int getLength() {
        return this.numSamples;
    }

    @Override
    public @NonNull ProblemList initialise(CaptureData captureData) {
        assert (!this.initialised);
        ProblemList problems = new ProblemList();
        int length = -1;
        for (CounterSeries i : this.counters) {
            problems.addAll(i.initialise(captureData));
            if (!i.isPresent()) continue;
            int iLength = i.getLength();
            assert (iLength >= 0);
            if (length < 0) {
                length = iLength;
            } else if (length != iLength) {
                throw new LogicError("SummationSeries: all series must be the same length");
            }
            this.anyPresent = true;
        }
        this.numSamples = Math.max(length, 0);
        this.initialised = true;
        Application.LOG.finest(() -> String.format("SummationSeries.initialise: numSamples=%d", this.numSamples));
        return problems;
    }

    @Override
    public boolean isPresent() {
        assert (this.initialised);
        return this.anyPresent;
    }

    @Override
    public double @NonNull [] toArray() {
        if (!this.isPresent()) {
            throw new LogicError("No data for series " + this.getName());
        }
        return SummationSeries.cacheValue(this.cachedResult, r -> {
            SoftReference softReference = this.cachedResult = r;
        }, () -> {
            double[] result = new double[this.numSamples];
            for (CounterSeries i : this.counters) {
                if (!i.isPresent()) continue;
                double[] d = i.toArray();
                assert (d.length == result.length);
                int n = 0;
                while (n < d.length) {
                    int n2 = n;
                    result[n2] = result[n2] + d[n];
                    ++n;
                }
            }
            return result;
        });
    }
}

