/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.counterseries;

import com.arm.streamline.common.model.counters.CounterDisplay;
import com.arm.streamline.model.capture.ISeriesDataProvider;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.capturedata.CounterNamesProvider;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.common.ResourceProblem;
import com.arm.streamline.performanceadvisor.counterseries.CounterDescriptor;
import com.arm.streamline.performanceadvisor.counterseries.CounterIdentifier;
import com.arm.streamline.performanceadvisor.counterseries.DataProviderSeries;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class StreamlineSeries
extends DataProviderSeries {
    private final @NonNull CounterDescriptor descriptor;
    private final boolean isOptional;
    private final boolean isPerFrame;

    public StreamlineSeries(@NonNull CounterDescriptor descriptor, boolean isOptional, boolean isPerFrame) {
        super(descriptor.getName());
        this.descriptor = descriptor;
        this.isOptional = isOptional;
        this.isPerFrame = isPerFrame;
    }

    public StreamlineSeries(@NonNull CounterDescriptor descriptor) {
        this(descriptor, false, false);
    }

    public StreamlineSeries(@NonNull CounterNamesProvider provider, @NonNull CounterIdentifier identifier) {
        this(CounterDescriptor.fromProvider(provider, identifier), false, false);
    }

    public StreamlineSeries(@NonNull String chartName, @NonNull String seriesName, @NonNull String seriesDescription, boolean isOptional, @NonNull CaptureData.BinType type, boolean isPerFrame) {
        this(CounterDescriptor.fromCustom(chartName, seriesName, seriesDescription, type), isOptional, isPerFrame);
    }

    @Override
    protected @Nullable ISeriesDataProvider initialiseDataSource(CaptureData captureData) {
        Optional<ISeriesDataProvider> dataSource = captureData.getSeriesForNames(this.descriptor.getCharts(), this.descriptor.getSeries());
        if (dataSource.isPresent() && this.descriptor.shouldAverage()) {
            dataSource.get().getConfig().setDisplay(CounterDisplay.AVERAGE);
        }
        return dataSource.orElse(null);
    }

    @Override
    protected ProblemList getProblems() {
        ProblemList problemList = new ProblemList();
        if (!this.isPresent() && !this.isOptional) {
            problemList.add(new ResourceProblem(ResourceProblem.Severity.ERROR, "Cannot find " + this.getName(), "Ensure your capture includes " + this.descriptor.listAliases()));
        }
        return problemList;
    }

    @Override
    public boolean isPerFrame() {
        return this.isPerFrame;
    }

    @Override
    public boolean isAverage() {
        return this.descriptor.shouldAverage();
    }

    @Override
    public boolean isMaximum() {
        return this.descriptor.shouldMax();
    }

    @Override
    public boolean isMinimum() {
        return this.descriptor.shouldMin();
    }
}

