/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.counterseries;

import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.counterseries.BasicSeries;
import com.arm.streamline.performanceadvisor.counterseries.CounterSeries;
import com.arm.streamline.performanceadvisor.counterseries.EmptySeries;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public class SelectOneSeries
extends BasicSeries {
    private @NonNull CounterSeries activeSeries;
    private final @NonNull List<@NonNull CounterSeries> counters;

    public SelectOneSeries(@NonNull String name, @NonNull CounterSeries first, @NonNull CounterSeries second) {
        this(name, new ArrayList<CounterSeries>());
        this.counters.add(first);
        this.counters.add(second);
    }

    public SelectOneSeries(@NonNull String name, @NonNull List<@NonNull CounterSeries> counters) {
        super(name);
        this.counters = counters;
        this.activeSeries = new EmptySeries();
    }

    @Override
    public int getLength() {
        return this.activeSeries.getLength();
    }

    @Override
    public @NonNull ProblemList initialise(CaptureData captureData) {
        ProblemList problems = new ProblemList();
        for (CounterSeries i : this.counters) {
            problems.addAll(i.initialise(captureData));
            if (!i.isPresent()) continue;
            Application.LOG.finest(() -> String.format("Selecting series %s for %s", i.getName(), this.getName()));
            this.activeSeries = i;
            break;
        }
        if (this.isPresent()) {
            problems.clear();
        }
        return problems;
    }

    @Override
    public boolean isPerFrame() {
        return this.activeSeries.isPerFrame();
    }

    @Override
    public boolean isPresent() {
        return this.activeSeries.isPresent();
    }

    @Override
    public double @NonNull [] toArray() {
        return this.activeSeries.toArray();
    }
}

