/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.counterseries;

import com.arm.streamline.common.model.counters.CounterDisplay;
import com.arm.streamline.model.capture.ISeriesDataProvider;
import com.arm.streamline.pa.StreamlineDataRepository;
import com.arm.streamline.performanceadvisor.capturedata.CachedDataSource;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.common.ResourceProblem;
import com.arm.streamline.performanceadvisor.counterseries.DataProviderSeries;
import com.arm.streamline.performanceadvisor.counterseries.SummationSeries;
import java.util.List;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class EglContextSeries
extends SummationSeries {
    private String[] charts;
    private boolean isAverageSeries;
    private boolean isPerFrame;

    public EglContextSeries(@NonNull String name, @NonNull String @NonNull [] charts, boolean isAverageSeries, boolean isPerFrame) {
        super(name);
        this.charts = charts;
        this.isAverageSeries = isAverageSeries;
        this.isPerFrame = isPerFrame;
    }

    @Override
    public boolean isPerFrame() {
        return this.isPerFrame;
    }

    @Override
    public ProblemList initialise(CaptureData captureData) {
        Optional<List<ISeriesDataProvider>> sourceList = captureData.getAllContextsInChart(this.charts);
        if (sourceList.isPresent()) {
            StreamlineDataRepository cache = captureData.getStreamlineDataRepository();
            for (ISeriesDataProvider src : sourceList.get()) {
                this.addComponent(new ContextSeries(new CachedDataSource(src, cache), this.isAverageSeries));
            }
        }
        ProblemList problemList = super.initialise(captureData);
        if (!this.isPresent()) {
            String description = this.getName().toLowerCase();
            problemList.add(new ResourceProblem(ResourceProblem.Severity.WARNING, "Cannot find " + description + " counter", "Use LWI or GA interceptor when creating your capture to obtain " + description + " data."));
        }
        return problemList;
    }

    private static final class ContextSeries
    extends DataProviderSeries {
        private final @NonNull ISeriesDataProvider provider;
        private boolean isAverageSeries;

        public ContextSeries(@NonNull ISeriesDataProvider provider, boolean isAverageSeries) {
            super("EGL context");
            this.provider = provider;
            this.isAverageSeries = isAverageSeries;
        }

        @Override
        protected @Nullable ISeriesDataProvider initialiseDataSource(CaptureData captureData) {
            if (this.isAverageSeries) {
                this.provider.getConfig().setDisplay(CounterDisplay.AVERAGE);
            }
            return this.provider;
        }
    }
}

