/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.counterseries;

import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.capturedata.CounterNamesProvider;
import com.arm.streamline.performanceadvisor.counterseries.CounterIdentifier;
import org.eclipse.jdt.annotation.NonNull;

public class CounterDescriptor {
    private final @NonNull String @NonNull [] charts;
    private final @NonNull CaptureData.BinType counterBinType;
    private final @NonNull String name;
    private final @NonNull String @NonNull [] series;

    public static @NonNull CounterDescriptor fromCustom(@NonNull String chartName, @NonNull String seriesName, @NonNull String seriesDescription, @NonNull CaptureData.BinType type) {
        return new CounterDescriptor(chartName, seriesName, seriesDescription, type);
    }

    public static @NonNull CounterDescriptor fromProvider(@NonNull CounterNamesProvider provider, @NonNull CounterIdentifier id) {
        String[] chartNames = provider.getChartNames(id);
        String[] seriesNames = provider.getSeriesNames(id);
        return new CounterDescriptor(chartNames, seriesNames, id);
    }

    private CounterDescriptor(@NonNull String chartName, @NonNull String seriesName, @NonNull String seriesDescription, @NonNull CaptureData.BinType counterBinType) {
        this.name = seriesDescription;
        this.charts = new String[]{chartName};
        this.series = new String[]{seriesName};
        this.counterBinType = counterBinType;
    }

    private CounterDescriptor(@NonNull String @NonNull [] chartAliases, @NonNull String @NonNull [] seriesAliases, @NonNull CounterIdentifier identifier) {
        this(chartAliases, seriesAliases, identifier.name);
    }

    CounterDescriptor(@NonNull String @NonNull [] chartAliases, @NonNull String @NonNull [] seriesAliases, @NonNull String name) {
        this.name = name;
        this.charts = new String[chartAliases.length * seriesAliases.length];
        this.series = new String[this.charts.length];
        int count = 0;
        String[] stringArray = chartAliases;
        int n = chartAliases.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            String[] stringArray2 = seriesAliases;
            int n3 = seriesAliases.length;
            int n4 = 0;
            while (n4 < n3) {
                String element2 = stringArray2[n4];
                this.charts[count] = element;
                this.series[count] = element2;
                ++count;
                ++n4;
            }
            ++n2;
        }
        this.counterBinType = CaptureData.BinType.NONE;
    }

    public @NonNull String @NonNull [] getCharts() {
        return this.charts;
    }

    public @NonNull String getName() {
        return this.name;
    }

    public @NonNull String @NonNull [] getSeries() {
        return this.series;
    }

    public @NonNull String listAliases() {
        StringBuilder aliases = new StringBuilder();
        int i = 0;
        while (i < this.charts.length) {
            if (i == 0) {
                aliases.append("'");
            } else {
                aliases.append(" or '");
            }
            aliases.append(this.charts[i] + " - " + this.series[i] + "'");
            ++i;
        }
        return aliases.toString();
    }

    public boolean shouldAverage() {
        return this.counterBinType == CaptureData.BinType.AVG;
    }

    public boolean shouldMax() {
        return this.counterBinType == CaptureData.BinType.MAX;
    }

    public boolean shouldMin() {
        return this.counterBinType == CaptureData.BinType.MIN;
    }
}

