/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.config;

import com.arm.streamline.performanceadvisor.common.LogicError;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import picocli.CommandLine;

public class ConfigItem<T> {
    private Class<?> type;
    private String name;
    private String description;
    private String label;
    private Optional<String> group;
    private Optional<T> value;
    private boolean isHidden;
    private boolean isDeveloperOnly;

    public ConfigItem(Class<?> type, String name, String description) {
        this.type = type;
        this.name = name;
        this.description = description;
        this.label = "value";
        this.group = Optional.empty();
        this.value = Optional.empty();
        this.isHidden = false;
        this.isDeveloperOnly = false;
        if (!name.matches("^[\\p{Alnum}-_]*$")) {
            throw new LogicError("Invalid characters in ConfigItem name %s" + name);
        }
    }

    public ConfigItem<T> setHidden(boolean isHidden) {
        this.isHidden = isHidden;
        return this;
    }

    public ConfigItem<T> setDeveloperOnly(boolean isDeveloperOnly) {
        this.isDeveloperOnly = isDeveloperOnly;
        return this;
    }

    public ConfigItem<T> setParameterLabel(String label) {
        this.label = label;
        return this;
    }

    public ConfigItem<T> setGroup(String group) {
        this.group = Optional.of(group);
        return this;
    }

    public Optional<String> getOptionalGroupName() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public String getLongOptionName() {
        return "--" + this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public boolean isDeveloperOnly() {
        return this.isDeveloperOnly;
    }

    public void setValue(@NonNull T rawValue) {
        this.value = Optional.of(rawValue);
    }

    public Optional<T> getOptional() {
        return this.value;
    }

    public boolean validate() {
        return this.getOptional().isPresent();
    }

    public CommandLine.Model.OptionSpec getOptionSpec() {
        return ((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder((String)this.getLongOptionName(), (String[])new String[0]).type(this.type)).paramLabel("<" + this.label + ">")).hidden(this.isHidden)).description(new String[]{this.description})).build();
    }
}

