/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.common;

import com.arm.streamline.performanceadvisor.analyser.Analyser;
import com.arm.streamline.performanceadvisor.capturedata.Provider;
import com.arm.streamline.performanceadvisor.common.Profiler;
import java.time.Duration;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class SimpleProfiler
implements Profiler {
    private Map<String, ProfileRecord> profileMap = new HashMap<String, ProfileRecord>();
    private Set<String> categories = new LinkedHashSet<String>();

    private ProfileSummary getProfileForCategory(String category) {
        List<ProfileRecord> timings = this.profileMap.values().stream().filter(record -> record.category.equals(category)).sorted().collect(Collectors.toList());
        return new ProfileSummary(timings);
    }

    private ProfileSummary getOverallProfile() {
        HashMap<String, ProfileRecord> totalsMap = new HashMap<String, ProfileRecord>();
        for (ProfileRecord i : this.profileMap.values()) {
            ProfileRecord record = totalsMap.getOrDefault(i.name, new ProfileRecord(i.name, "totals"));
            if (i.total().toMillis() <= 0L) continue;
            for (Map.Entry<Profiler.Phase, Duration> entry : i.durations.entrySet()) {
                record.add(entry.getKey(), entry.getValue());
            }
            totalsMap.put(i.name, record);
        }
        List<ProfileRecord> timings = totalsMap.values().stream().sorted((l, r) -> r.total().compareTo(l.total())).collect(Collectors.toList());
        return new ProfileSummary(timings);
    }

    @Override
    public final void printProfile(Consumer<String> dest, boolean perCategory) {
        if (perCategory) {
            for (String category : this.categories) {
                dest.accept(String.format("%s:", category));
                this.getProfileForCategory(category).outputSummary(dest);
            }
        }
        if (perCategory) {
            dest.accept("Overall:");
        }
        this.getOverallProfile().outputSummary(dest);
    }

    @Override
    public void record(String name, Profiler.Phase phase, String category, Duration duration) {
        this.categories.add(category);
        String id = category + ":" + name;
        ProfileRecord record = this.profileMap.getOrDefault(id, new ProfileRecord(name, category));
        record.add(phase, duration);
        this.profileMap.put(id, record);
    }

    @Override
    public void record(Analyser analyser, String report, Profiler.Phase phase, Duration duration) {
        this.record(analyser.name(), phase, report, duration);
    }

    @Override
    public void record(Provider provider, Profiler.Phase phase, Duration duration) {
        this.record(provider.name(), phase, "Providers", duration);
    }

    private static class ProfileRecord
    implements Comparable<ProfileRecord> {
        private String name;
        private String category;
        private Map<Profiler.Phase, Duration> durations;

        public ProfileRecord(String name, String category) {
            this.name = name;
            this.category = category;
            this.durations = new EnumMap<Profiler.Phase, Duration>(Profiler.Phase.class);
        }

        @Override
        public int compareTo(ProfileRecord record) {
            return (this.category + this.name).compareTo(record.category + record.name);
        }

        public int hashCode() {
            return Objects.hash(this.category, this.name);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ProfileRecord)) {
                return false;
            }
            ProfileRecord other = (ProfileRecord)obj;
            return Objects.equals(this.category, other.category) && Objects.equals(this.name, other.name);
        }

        public Duration duration(Profiler.Phase phase) {
            return this.durations.getOrDefault((Object)phase, Duration.ZERO);
        }

        public void add(Profiler.Phase phase, Duration d) {
            this.durations.put(phase, d.plus(this.duration(phase)));
        }

        public Duration total() {
            Duration sum = Duration.ZERO;
            for (Duration i : this.durations.values()) {
                sum = sum.plus(i);
            }
            return sum;
        }
    }

    private static class ProfileSummary {
        private static final int MIN_FIELD_WIDTH = 5;
        private static final int UNITS_WIDTH = 3;
        private static final int PERCENTAGE_WIDTH = 5;
        private static final int BAR_WIDTH = 20;
        private List<ProfileRecord> records;
        private int nameWidth;
        private int fieldWidth;
        private boolean showProportion;
        private Duration overallInit = Duration.ZERO;
        private Duration overallExec = Duration.ZERO;
        private Duration overallSum = Duration.ZERO;
        private long maxSum = 0L;
        private double maxPercentage = 0.0;

        public ProfileSummary(List<ProfileRecord> records) {
            this.records = records;
            int maxNameLength = 0;
            for (ProfileRecord i : records) {
                this.overallInit = this.overallInit.plus(i.duration(Profiler.Phase.INIT));
                this.overallExec = this.overallExec.plus(i.duration(Profiler.Phase.EXEC));
                this.maxSum = Math.max(i.total().toMillis(), this.maxSum);
                maxNameLength = Math.max(i.name.length(), maxNameLength);
            }
            this.overallSum = this.overallInit.plus(this.overallExec);
            this.nameWidth = Math.max(10, maxNameLength + 1);
            boolean bl = this.showProportion = (double)this.overallSum.toMillis() > 0.0;
            if (this.showProportion) {
                this.maxPercentage = Math.round(100.0 * (double)this.maxSum / (double)this.overallSum.toMillis());
            }
        }

        private int numDigits(long value) {
            assert (value >= 0L);
            return value == 0L ? 1 : 1 + (int)Math.floor(Math.log10(value));
        }

        public void outputSummary(Consumer<String> dest) {
            this.fieldWidth = Math.max(5, this.numDigits(this.maxSum) + 1);
            int columnWidth = this.fieldWidth + 3 + 1;
            int dividerWidth = this.nameWidth + columnWidth * 3 + 5 + 20;
            String divider = String.join((CharSequence)"", Collections.nCopies(dividerWidth, "-"));
            dest.accept(divider);
            dest.accept(String.format("%s%s%s%s    Proportion", this.rightPad("Component", this.nameWidth - 1), this.leftPad("Init", columnWidth), this.leftPad("Exec", columnWidth), this.leftPad("Total", columnWidth)));
            dest.accept(divider);
            for (ProfileRecord i : this.records) {
                String row = String.format("%s %s %s %s", this.rightPad(i.name, this.nameWidth), this.columnStr(i.duration(Profiler.Phase.INIT).toMillis()), this.columnStr(i.duration(Profiler.Phase.EXEC).toMillis()), this.columnStr(i.total().toMillis()));
                if (this.showProportion) {
                    int percentage = (int)Math.round(100.0 * (double)i.total().toMillis() / (double)this.overallSum.toMillis());
                    int componentPercentage = (int)Math.round(100.0 * (double)percentage / this.maxPercentage);
                    dest.accept(String.format("%s %3d%% %s", row, percentage, this.bar(componentPercentage, 20)));
                    continue;
                }
                dest.accept(row);
            }
            dest.accept("");
            dest.accept(String.format("%s %s %s %s", this.rightPad("Totals", this.nameWidth), this.columnStr(this.overallInit.toMillis()), this.columnStr(this.overallExec.toMillis()), this.columnStr(this.overallInit.plus(this.overallExec).toMillis())));
            dest.accept(divider);
            dest.accept("");
        }

        private String columnStr(long value) {
            StringBuilder fmt = new StringBuilder("%");
            fmt.append(this.fieldWidth);
            fmt.append("d ms");
            return String.format(fmt.toString(), value);
        }

        private String rightPad(String str, int width) {
            StringBuilder fmt = new StringBuilder("%-");
            fmt.append(width);
            fmt.append('s');
            return String.format(fmt.toString(), str);
        }

        private String leftPad(String str, int width) {
            StringBuilder fmt = new StringBuilder("%");
            fmt.append(width);
            fmt.append('s');
            return String.format(fmt.toString(), str);
        }

        private String bar(int percentage, int width) {
            int clamped = Math.min(Math.max(percentage, 0), 100);
            int numChars = Math.floorDiv(width * clamped, 100);
            return String.join((CharSequence)"", Collections.nCopies(numChars, "#")) + String.join((CharSequence)"", Collections.nCopies(width - numChars, " "));
        }
    }
}

