/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.capturesource;

import com.arm.streamline.performanceadvisor.capturesource.CaptureHandler;
import com.arm.streamline.performanceadvisor.capturesource.TempDirectory;
import com.arm.streamline.performanceadvisor.common.FatalError;
import com.arm.streamline.performanceadvisor.io.UserProvidedPath;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

public class HandlerReadOnly
extends CaptureHandler {
    private TempDirectory tempDir;

    @Override
    public boolean canProcessCapture(Path path) {
        return Files.isDirectory(path, new LinkOption[0]) && !Files.isWritable(path) && Files.isReadable(path);
    }

    @Override
    public File workingDirectory(UserProvidedPath path) {
        System.out.println("Warning: directory " + String.valueOf(path.getUserProvidedPath()) + " is read-only.");
        System.out.println("Making a temporary copy to allow Streamline analysis.");
        Path adjustedPath = path.getAdjustedPath();
        this.checkExpectedContent(adjustedPath.toFile());
        this.tempDir = new TempDirectory("pa_ro-");
        this.copyDirectory(adjustedPath, this.tempDir.getPath());
        Path rootFolder = adjustedPath.getFileName();
        return this.tempDir.getPath().resolve(rootFolder).toFile();
    }

    @Override
    public void close() {
        if (this.tempDir != null) {
            this.tempDir.close();
        }
    }

    private void copyDirectory(final Path source, Path destination) {
        try {
            final Path rootFolder = destination.resolve(source.getFileName());
            Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attr) throws IOException {
                    Path target = rootFolder.resolve(source.relativize(path));
                    Files.createDirectory(target, new FileAttribute[0]);
                    return super.preVisitDirectory(path, attr);
                }

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                    Path target = rootFolder.resolve(source.relativize(path));
                    Files.copy(path, target, new CopyOption[0]);
                    return super.visitFile(path, attrs);
                }
            });
        }
        catch (IOException e) {
            throw new FatalError("Copy operation failed: " + e.getMessage(), e);
        }
    }
}

