/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.capturesource;

import com.arm.streamline.performanceadvisor.common.FatalError;
import com.arm.streamline.performanceadvisor.io.UserProvidedPath;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class CaptureHandler {
    public abstract boolean canProcessCapture(Path var1);

    public abstract File workingDirectory(UserProvidedPath var1);

    public void close() {
    }

    protected List<String> getRootFileList(File dir) {
        ArrayList<String> content = new ArrayList<String>();
        File[] fileList = dir.listFiles();
        if (fileList != null) {
            File[] fileArray = fileList;
            int n = fileList.length;
            int n2 = 0;
            while (n2 < n) {
                File i = fileArray[n2];
                content.add(i.getName());
                ++n2;
            }
        }
        return content;
    }

    protected boolean hasExpectedContent(List<String> rootFileList) {
        ArrayList<String> required = new ArrayList<String>(Arrays.asList("0000000000", "captured.xml", "counters.xml", "events.xml"));
        return rootFileList.containsAll(required);
    }

    protected void checkExpectedContent(File dir) {
        if (!this.hasExpectedContent(this.getRootFileList(dir))) {
            throw new FatalError("Invalid capture");
        }
    }
}

