/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.capturedata.serialisation;

import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.capturedata.CpuProvider;
import com.arm.streamline.performanceadvisor.capturedata.FpsProvider;
import com.arm.streamline.performanceadvisor.capturedata.FrameProvider;
import com.arm.streamline.performanceadvisor.capturedata.Region;
import com.arm.streamline.performanceadvisor.capturedata.gpuprovider.GpuProvider;
import com.arm.streamline.performanceadvisor.capturedata.serialisation.Serialisation;
import com.arm.streamline.performanceadvisor.capturedata.serialisation.SerialisationCalculator;
import com.arm.streamline.performanceadvisor.common.VectorUtils;
import com.arm.streamline.performanceadvisor.counterseries.CounterSeries;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;

public class JobManagerSerialisationCalculator
implements SerialisationCalculator {
    private static final double THRESHOLD = 0.85;
    private CpuProvider cpuProvider;
    private GpuProvider gpuProvider;
    private FrameProvider frameProvider;
    private FpsProvider fpsProvider;
    private CounterSeries fragmentActivity;
    private CounterSeries nonFragmentActivity;
    private CaptureData captureData;

    public JobManagerSerialisationCalculator(CaptureData captureData, CounterSeries fragmentActivity, CounterSeries nonFragmentActivity) {
        this.captureData = captureData;
        this.cpuProvider = captureData.getCpuProvider();
        this.gpuProvider = captureData.getGpuProvider();
        this.frameProvider = captureData.getFrameProvider();
        this.fpsProvider = captureData.getFpsProvider();
        this.fragmentActivity = fragmentActivity;
        this.nonFragmentActivity = nonFragmentActivity;
    }

    @Override
    public Serialisation getSerialisation(Region region) {
        if (this.cpuProvider.getMainThread() == null) {
            return new Serialisation(false, false);
        }
        Application.LOG.fine(() -> "Checking region " + region.getName() + " for serialisation.");
        double targetFps = this.captureData.getTargetFrameRate().getAsFps();
        int sliceLength = targetFps < 31.0 ? 33 : 16;
        Application.LOG.fine(() -> "Slice length is " + sliceLength);
        double[] regionCpuUsage = this.cpuProvider.getUsage().toArray(region.getStart(), region.getEnd());
        double[] regionGpuUsage = this.gpuProvider.getUtilisation().toArray(region.getStart(), region.getEnd());
        double[] regionVertUsage = this.nonFragmentActivity.toArray(region.getStart(), region.getEnd());
        double[] regionFragUsage = this.fragmentActivity.toArray(region.getStart(), region.getEnd());
        boolean foundCpuGpuSerialisation = false;
        boolean foundVertFragSerialisation = false;
        int firstFrameStart = (int)this.frameProvider.getFrameStarts()[0];
        Application.LOG.fine(() -> "First frame starts at " + firstFrameStart);
        int i = 0;
        while (i < region.getEnd() - region.getStart()) {
            if (Application.LOG.isLoggable(Level.FINE)) {
                int sliceStart = region.getStart() + i;
                int sliceEnd = sliceStart + sliceLength;
                Application.LOG.fine("----------------------");
                Application.LOG.fine("Slice start: " + sliceStart);
                Application.LOG.fine("Slice end: " + sliceEnd);
            }
            ArrayList<Double> fpsList = new ArrayList<Double>();
            int j = i;
            while (j < i + sliceLength) {
                fpsList.add(this.fpsProvider.getPerBin().getFpsAt(region.getStart() + j));
                ++j;
            }
            double[] fps = fpsList.stream().mapToDouble(Double::doubleValue).toArray();
            double avgFps = VectorUtils.avg(fps);
            Application.LOG.fine("Fps for slice: ");
            Application.LOG.fine(() -> Arrays.toString(fps));
            Application.LOG.fine(() -> "Average fps: " + avgFps);
            if (region.getStart() + i >= firstFrameStart && !(avgFps > targetFps * 0.95)) {
                double[] cpuUsage = Arrays.copyOfRange(regionCpuUsage, i, i + sliceLength);
                double[] gpuUsage = Arrays.copyOfRange(regionGpuUsage, i, i + sliceLength);
                foundCpuGpuSerialisation = JobManagerSerialisationCalculator.detectCpuGpuSerialisation(cpuUsage, gpuUsage);
                if (VectorUtils.avg(gpuUsage) > 0.85) {
                    double[] vertUsage = Arrays.copyOfRange(regionVertUsage, i, i + sliceLength);
                    double[] fragUsage = Arrays.copyOfRange(regionFragUsage, i, i + sliceLength);
                    foundVertFragSerialisation = JobManagerSerialisationCalculator.detectVertFragSerialisation(vertUsage, fragUsage);
                }
            }
            i += sliceLength;
        }
        return new Serialisation(foundCpuGpuSerialisation, foundVertFragSerialisation);
    }

    private static boolean detectCpuGpuSerialisation(double[] cpuUsage, double[] gpuUsage) {
        double avgCpu = VectorUtils.avg(cpuUsage);
        double avgGpu = VectorUtils.avg(gpuUsage);
        Application.LOG.fine("Cpu usage for slice: ");
        Application.LOG.fine(() -> Arrays.toString(cpuUsage));
        Application.LOG.fine(() -> "Average cpu: " + avgCpu);
        Application.LOG.fine("Gpu usage for slice: ");
        Application.LOG.fine(() -> Arrays.toString(gpuUsage));
        Application.LOG.fine(() -> "Average gpu: " + avgGpu);
        if (avgCpu < 0.85 && avgGpu < 0.85) {
            Application.LOG.fine("CPU-GPU serialisation problem here");
            return true;
        }
        return false;
    }

    private static boolean detectVertFragSerialisation(double[] vertUsage, double[] fragUsage) {
        double avgVert = VectorUtils.avg(vertUsage);
        double avgFrag = VectorUtils.avg(fragUsage);
        Application.LOG.fine("Vert usage for slice: ");
        Application.LOG.fine(() -> Arrays.toString(vertUsage));
        Application.LOG.fine(() -> "Average vert: " + avgVert);
        Application.LOG.fine("Frag usage for slice: ");
        Application.LOG.fine(() -> Arrays.toString(fragUsage));
        Application.LOG.fine(() -> "Average frag: " + avgFrag);
        if (avgVert < 0.85 && avgFrag < 0.85) {
            Application.LOG.fine("Vert-frag serialisation problem here");
            return true;
        }
        return false;
    }
}

