/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.capturedata.gpuprovider;

import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.capturedata.CounterNamesProvider;
import com.arm.streamline.performanceadvisor.capturedata.gpuprovider.CsfGpuProvider;
import com.arm.streamline.performanceadvisor.capturedata.gpuprovider.FifthGenGpuProvider;
import com.arm.streamline.performanceadvisor.capturedata.gpuprovider.GpuProvider;
import com.arm.streamline.performanceadvisor.capturedata.gpuprovider.JmGpuProvider;
import com.arm.streamline.performanceadvisor.counterseries.CounterIdentifier;

public class GpuProviderFactory {
    public static GpuProvider create(CaptureData captureData) {
        CounterNamesProvider counterNamesProvider = captureData.getCounterNamesProvider();
        boolean hasBinningQueue = counterNamesProvider.counterExists(CounterIdentifier.MaliBinningQueueUtil);
        if (hasBinningQueue) {
            return new FifthGenGpuProvider(captureData);
        }
        boolean hasComputeQueue = counterNamesProvider.counterExists(CounterIdentifier.MaliCompQueueUtil);
        if (hasComputeQueue) {
            return new CsfGpuProvider(captureData);
        }
        return new JmGpuProvider(captureData);
    }
}

