/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.capturedata.gpuprovider;

import com.arm.streamline.performanceadvisor.capturedata.BoundnessType;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.capturedata.gpuprovider.GpuProvider;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.counterseries.BoundnessLabelledDoubleArray;
import com.arm.streamline.performanceadvisor.counterseries.CounterDescriptor;
import com.arm.streamline.performanceadvisor.counterseries.CounterIdentifier;
import com.arm.streamline.performanceadvisor.counterseries.CounterSeries;
import com.arm.streamline.performanceadvisor.counterseries.StreamlineSeries;

public class CsfGpuProvider
extends GpuProvider {
    private CounterSeries vertexUtil;
    private CounterSeries computeUtil;
    private CounterSeries fragmentUtil;

    public CsfGpuProvider(CaptureData captureData) {
        super(captureData);
        this.computeUtil = new StreamlineSeries(CounterDescriptor.fromProvider(this.counterNamesProvider, CounterIdentifier.MaliCompQueueUtil));
        this.vertexUtil = new StreamlineSeries(CounterDescriptor.fromProvider(this.counterNamesProvider, CounterIdentifier.MaliVertQueueUtil));
        this.fragmentUtil = new StreamlineSeries(CounterDescriptor.fromProvider(this.counterNamesProvider, CounterIdentifier.MaliFragQueueUtil));
    }

    @Override
    public ProblemList initialise() {
        ProblemList problems = super.initialise();
        problems.addAll(this.computeUtil.initialise(this.captureData));
        problems.addAll(this.vertexUtil.initialise(this.captureData));
        problems.addAll(this.fragmentUtil.initialise(this.captureData));
        return problems;
    }

    @Override
    public void execute() {
        super.execute();
        this.labelledQueueActivities.add(new BoundnessLabelledDoubleArray(BoundnessType.COMPUTE, this.computeUtil.toArray()));
        this.labelledQueueActivities.add(new BoundnessLabelledDoubleArray(BoundnessType.VERTEX, this.vertexUtil.toArray()));
        this.labelledQueueActivities.add(new BoundnessLabelledDoubleArray(BoundnessType.FRAGMENT, this.fragmentUtil.toArray()));
    }
}

